package com.fshows.lifecircle.service.pay.openapi.facade.domain.enums;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.enums
 * 功能：
 * 创建时间：2018-03-03 14:49
 * 更新记录：
 *
 * @author BuHao
 */
public enum PayTypeEnum {

  /**
   * 微信刷卡支付
   */
  WXPAY_SWIPE_CARD(2012, "WXPAY_SWIPE_CARD"),
  /**
   * 微信扫码支付
   */
  WXPAY_SCAN_QRCODE(2013, "WXPAY_SCAN_QRCODE"),
  /**
   * 微信公众号支付
   */
  WXPAY_MP(2011, "WXPAY_MP"),
  /**
   * 支付宝刷卡支付
   */
  ALIPAY_SWIPE_CARD(1012, "ALIPAY_SWIPE_CARD"),
  /**
   * 支付宝扫码支付
   */
  ALIPAY_SCAN_QRCODE(1013, "ALIPAY_SCAN_QRCODE"),
  /**
   * 支付宝JS支付
   */
  ALIPAY_JS_API(1011, "ALIPAY_JS_API");


  /**
   * 支付类型 Id
   */
  private Integer payTypeId;
  /**
   * 支付类型名称
   */
  private String payTypeName;

  PayTypeEnum(Integer payTypeId, String payTypeName) {
    this.payTypeId = payTypeId;
    this.payTypeName = payTypeName;
  }

  public Integer getPayTypeId() {
    return payTypeId;
  }

  public String getPayTypeName() {
    return payTypeName;
  }
}
