package com.fshows.lifecircle.service.pay.openapi.facade.domain.enums;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.openapi.facade.domain.enums
 * 功能：支付渠道枚举（fb_pay_channel）
 * 创建时间：2018-03-03 14:47
 * 更新记录：
 *
 * @author BuHao
 */
public enum PayChannelEnum {

  /**
   * 支付宝
   */
  ALIPAY(101, "ALIPAY"),
  /**
   * 微信
   */
  WXPAY(201, "WXPAY");

  /**
   * 渠道 id
   */
  private Integer channelId;
  /**
   * 渠道名
   */
  private String channelName;

  PayChannelEnum(Integer channelId, String channelName) {
    this.channelId = channelId;
    this.channelName = channelName;
  }

  public Integer getChannelId() {
    return channelId;
  }

  public String getChannelName() {
    return channelName;
  }
}
