package com.fshows.lifecircle.service.pay.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.pay.openapi.facade.domain.rate.*;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.PageResult;

import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Optional;

/***
 * @author spafka
 */
public interface IRateApi {


    BizResponse<RateResult> getRate(RateParam param);

    BizResponse<Optional<FbRateBaseResult>> getBaseRateSetting(Long oemId, Integer channelId);

    BizResponse<Optional<Boolean>> saveOemRate(FbOemRateParam param);

    BizResponse<Optional< List<FbOemRateResult>>> getOemRateSetting(Long oemId, @Nullable Integer channelId);

    BizResponse<Optional<List<FbAgentRateResult> >> getAgentRateSetting(Long agentId, @Nullable Integer channelId);

    BizResponse<Optional<  List<FbMerchantRateResult>>> getMerchantRateSetting(Long mid, @Nullable Integer channelId);

    BizResponse<Optional<Boolean>> saveBaseRate(FbRateBaseParam param);

    BizResponse<Optional<Boolean>> saveAgentRate(FbAgentRateParam param);

    BizResponse<Optional<Boolean>> saveMerchantRate(FbMerchantRateParam param);

    BizResponse<List<CurrentRateResult> > getAgentCurrentRate(Long agentId);

    BizResponse<List<CurrentRateResult> > getMerchantCurrentRate(Long mid);

    BizResponse<List<CurrentRateResult> > getOemCurrentRate(Long oemId);

    BizResponse<Optional<List<FbPayChannelResult>>> getPayChannels();

    BizResponse<Optional<Boolean>> saveLog(FbRateChangeLogParam param);

    BizResponse<Optional<PageResult<FbRateChangeLogResult>>> getChangeLog(@Nullable Long bizId,@Nullable  Integer type, @Nullable Integer channelId, @NotNull Integer page, @NotNull Integer pageSize);

    BizResponse<Optional<Boolean>> saveGrantDefaultSetting(FbGrantDefaultRateParam param);

    BizResponse<Optional<List<FbGrantDefaultRateResult>>> getFbGrantDefaultRateSetting(Long agentId, @Nullable Integer channelId);

    BizResponse<Optional<List<SignInfoResult>>> getSignInfos(Long oemId);

    BizResponse<Optional<List<FbMerchantRateResult>>> getFbMerchantRateByMidz(@NotNull List<Long> mids);

    BizResponse<Optional<List<FbAgentRateResult>>> getFbAgentRateResultByAgentIds(@NotNull List<Long> agentIds);

    BizResponse<Optional<List<FbOemRateResult>>> getFbOemRateResultByOemids(@NotNull List<Long> oemIds);
}
