package com.fshows.lifecircle.service.pay.manager.user.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.user.PushManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IAppUserPushApi;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.pay.manager.impl
 * @description：描述:推送Service
 * @updateDesription：更新记录描述
 * @date：2018/2/1
 * @author：Wendy
 */
@Service
@Slf4j
public class IPushManagerImpl implements PushManager{
    @HSFConsumer
    IAppUserPushApi appUserPushApi;

    @Override
    public BizResponse<Boolean> push(String content) throws RpcInvokingException {
        return appUserPushApi.apiPush(content);
    }
}
