/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IUserRightConfigManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IUserRightConfigApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.constants.UserType;
import com.fshows.lifecircle.service.user.openapi.facade.domain.righconfig.RightControlDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import java.util.List;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.manager.impl
 * 功能：
 * 创建时间：2018-03-07 19:36
 * 更新记录：
 * @author BuHao
 */
@Service
public class UserRightConfigManagerImpl implements IUserRightConfigManager {

  @HSFConsumer
  private IUserRightConfigApi userRightConfigApi;

  /**
   * 根据用户id 获得所拥有的功能权限列表
   */
  @Override
  public List<RightControlDTO> queryUserRightControlList(long userId) throws RpcInvokingException {

    BizResponse<List<RightControlDTO>> response = userRightConfigApi
        .queryUserRightControlList(UserType.MERCHANT, userId);

    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }
}
