/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IUserMerchantChildrenManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IUserMerchantChildrenApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantChildrenDetailDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.manager.impl
 * 功能：
 * 创建时间：2018-03-05 15:07
 * 更新记录：
 * @author BuHao
 */
@Service
public class UserMerchantChildrenManagerImpl implements IUserMerchantChildrenManager {

  @HSFConsumer
  private IUserMerchantChildrenApi userMerchantChildrenApi;

  /**
   * 商户子账号信息查询
   */
  @Override
  public MerchantChildrenDetailDTO getUserMerchantChildrenByBaseId(Long baseId)
      throws RpcInvokingException {

    BizResponse<MerchantChildrenDetailDTO> response = userMerchantChildrenApi
        .getUserMerchantChildrenByBaseId(baseId);

    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }
}
