package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IStoreManager;
import com.fshows.lifecircle.service.store.openapi.facade.api.rpc.IStoreApi;
import com.fshows.lifecircle.service.store.openapi.facade.domain.StoreInfoResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 所在的包名: com.fshows.lifecircle.service.pay.manager.impl
 * 所在的项目名：lifecircle-service-pay
 *
 * @Author:xukh
 * @Description:
 * @Date: Created in 14:42 2018/3/2
 */
@Service
public class StoreManagerImpl implements IStoreManager {

    @HSFConsumer
    private IStoreApi storeApi;

    @Override
    public StoreInfoResult getByStoreId(Long storeId) throws RpcInvokingException {
        BizResponse<StoreInfoResult> response = storeApi.getByStoreId(storeId);
        if (!response.isSuccess()) {
            throw new RpcInvokingException(response.getResultCode(), response.getErrorMessage());
        }
        return response.getData();
    }
}
