/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IOemManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IOemApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.result.oem.OemResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.manager.impl
 * 功能：
 * 创建时间：2018-03-05 15:00
 * 更新记录：
 * @author BuHao
 */
@Service
public class OemManagerImpl implements IOemManager {

  @HSFConsumer
  private IOemApi oemApi;

  /**
   * 查询 oem 信息
   */
  @Override
  public OemResult getOemByOemId(Long oemID) throws RpcInvokingException {

    BizResponse<OemResult> response = oemApi.getOemByOemId(oemID);
    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }
}
