/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IMerchantManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IUserMerchantApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.merchant.MerchantDetailDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 功能：商户管理Manager实现类
 * 创建时间：2017-12-20 09:19
 * 更新记录：
 *
 * @author caofy
 */
@Service
public class MerchantManagerImpl implements IMerchantManager {

  @HSFConsumer
  private IUserMerchantApi userMerchantApi;

  @Override
  public MerchantDetailDTO queryMerchantByMid(Long mid) throws RpcInvokingException {

    BizResponse<MerchantDetailDTO> response = userMerchantApi.queryUserMerchantByMid(mid);

    if (!response.isSuccess()) {
      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }

    return response.getData();
  }
}
