/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IConsumerManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IConsumerApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.consumer.ConsumerAddOrUpdateParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.consumer.ConsumerQueryParam;
import com.fshows.lifecircle.service.user.openapi.facade.domain.consumer.ConsumerQueryResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-pay-facade
 * 包名：com.fshows.lifecircle.service.payfacade.manager.impl
 * 功能：
 * 创建时间：2018-03-02 17:54
 * 更新记录：
 * @author BuHao
 */
@Service
public class ConsumerManagerImpl implements IConsumerManager {

  @HSFConsumer
  private IConsumerApi consumerApi;

  /**
   * 添加或删除用户
   */
  @Override
  public Boolean addOrUpdate(ConsumerAddOrUpdateParam param) throws RpcInvokingException {

    BizResponse<Boolean> response = consumerApi.addOrUpdate(param);

    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }

  /**
   * 查询商户
   */
  @Override
  public ConsumerQueryResult query(ConsumerQueryParam param) throws RpcInvokingException {

    BizResponse<ConsumerQueryResult> response = consumerApi.query(param);

    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }
}
