/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.pay.manager.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.fshows.lifecircle.service.pay.manager.IAgentManager;
import com.fshows.lifecircle.service.user.openapi.facade.api.rpc.IUserAgentApi;
import com.fshows.lifecircle.service.user.openapi.facade.domain.agent.AgentDetailDTO;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.exception.RpcInvokingException;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-pay
 * 包名：com.fshows.lifecircle.service.pay.manager.impl
 * 功能：
 * 创建时间：2018-03-05 15:05
 * 更新记录：
 * @author BuHao
 */
@Service
public class AgentManagerImpl implements IAgentManager {

  @HSFConsumer
  private IUserAgentApi userAgentApi;

  /**
   * 查询代理商信息
   */
  @Override
  public AgentDetailDTO queryUserAgentByAgentId(Long agentId) throws RpcInvokingException {

    BizResponse<AgentDetailDTO> response = userAgentApi
        .queryUserAgentByAgentId(agentId);

    if (!response.isSuccess()){

      throw new RpcInvokingException(response.getErrorCode(), response.getErrorMessage());
    }
    return response.getData();
  }
}
