/**
 * Copyright (c) 2018, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.operation.business.impl.biz;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.fshows.lifecircle.service.operation.business.biz.IAppInfoService;
import com.fshows.lifecircle.service.operation.business.db.IFbAppLaunchPageService;
import com.fshows.lifecircle.service.operation.business.db.IFbAppVersionService;
import com.fshows.lifecircle.service.operation.business.db.IFbSystemConfigService;
import com.fshows.lifecircle.service.operation.domain.po.FbAppLaunchPage;
import com.fshows.lifecircle.service.operation.domain.po.FbAppVersion;
import com.fshows.lifecircle.service.operation.domain.po.FbSystemConfig;
import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppLaunchPageResult;
import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppProtocolResult;
import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppVersionResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 项目：lifecircle-service-operation
 * 包名：com.fshows.lifecircle.service.operation.business.impl.biz
 * 功能：
 * 创建时间：2018-01-08 11:02
 * 更新记录：
 *
 * @author BuHao
 */
@Service
public class AppInfoImpl implements IAppInfoService {

  @Autowired
  private IFbAppVersionService fbAppVersionService;
  @Autowired
  private IFbAppLaunchPageService fbAppLaunchPageService;
  @Autowired
  private IFbSystemConfigService fbSystemConfigService;

  @Override
  public AppVersionResult getUrlByLatestVersion(String appName) {

    // 获得最新一条 app 版本信息
    FbAppVersion fbAppVersion = fbAppVersionService.selectOne(
        new EntityWrapper<FbAppVersion>().eq(FbAppVersion.IS_DEL, 0)
            .eq(FbAppVersion.APP_NAME, appName).eq(FbAppVersion.STATUS, 1)
            .orderBy(FbAppVersion.ID, false));

    if (fbAppVersion != null) {

      return new AppVersionResult().setApkUrl(fbAppVersion.getDownloadUrl())
          .setContent(fbAppVersion.getUpdateMsg()).setVersion(fbAppVersion.getVersionCode())
          .setIsMandatoryUpdate(fbAppVersion.getIsMustUpdate());
    }

    return null;
  }

  /**
   * 获得 app 启动页
   */
  @Override
  public AppLaunchPageResult getLaunchPage(Long oemId) {

    // 获得启动页信息
    FbAppLaunchPage appLaunchPage = fbAppLaunchPageService.selectOne(
        new EntityWrapper<FbAppLaunchPage>().eq(FbAppLaunchPage.IS_DEL, 0)
            .eq(FbAppLaunchPage.OEM_ID, oemId));

    if (appLaunchPage != null) {

      return new AppLaunchPageResult().setJumpTitle(appLaunchPage.getTitle())
          .setStartPic(appLaunchPage.getPageUrl()).setJumpUrl(appLaunchPage.getLinkUrl());
    }

    return null;
  }

  /**
   * 获得
   *
   * @param protocolType 协议类型
   */
  @Override
  public AppProtocolResult getProtocolInfo(String protocolType) {

    FbSystemConfig protocol = fbSystemConfigService.selectOne(
        new EntityWrapper<FbSystemConfig>().eq(FbSystemConfig.IS_DEL, 0)
            .eq(FbSystemConfig.CONFIG_KEY, protocolType));

    if (protocol != null) {

      return new AppProtocolResult().setProtocol(protocol.getConfigValue())
          .setTitle(protocol.getTitle());
    }

    return null;
  }
}
