/**
 * 项目：lifecircle-service-operation
 * 包名：com.fshows.lifecircle.service.operation.openapi.facade.api.rpc
 * 功能：
 * 创建时间：2018-01-08 10:40
 * 更新记录：
 *
 * @author BuHao
 */
package com.fshows.lifecircle.service.operation.openapi.facade.api.rpc;

import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppLaunchPageResult;
import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppProtocolResult;
import com.fshows.lifecircle.service.operation.openapi.facade.domain.result.AppVersionResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;

/**
 * 项目：lifecircle-service-operation
 * 包名：com.fshows.lifecircle.service.operation.openapi.facade.api.rpc
 * 功能：app 版本控制 api
 * 创建时间：2018-01-08 10:40
 * 更新记录：
 * @author BuHao
 */
public interface IAppInfoApi {

  /**
   * 获得
   * @param appName
   * @return
   */
  BizResponse<AppVersionResult> getUrlByLatestVersion(String appName);

  /**
   * 获得 app 启动页
   * @param oemId
   */
  BizResponse<AppLaunchPageResult> getLaunchPage(Long oemId);

  /**
   * 获得
   * @param protocolType 协议类型
   * @return
   */
  BizResponse<AppProtocolResult> getProtocolInfo(String protocolType);
}
