/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fshows.lifecircle.service.commons.service.utils.JsonUtil;
import com.fshows.lifecircle.service.openapi.facade.domain.result.LiquidationCommonResult;
import com.fshows.lifecircle.service.service.contants.LiquidationConstants;
import com.fshows.lifecircle.service.service.utils.RequestUtil;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CallLiquidationPlaformService {
    private static final Logger log = LoggerFactory.getLogger(CallLiquidationPlaformService.class);
    private static final String VERSION = "1.0";

    public LiquidationCommonResult call(String method, Map<String, Object> contentMap) {
        try {
            return this.call(method, JsonUtil.getJsonByCamelPojo(contentMap));
        }
        catch (JsonProcessingException e) {
            log.error("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u65f6pojo\u9a7c\u5cf0\u8f6c\u6362\u5931\u8d25 method={};contentMap={}; ex = {}", new Object[]{method, JSON.toJSONString(contentMap), ExceptionUtils.getStackTrace((Throwable)e)});
            return LiquidationCommonResult.commonError((String)"\u53c2\u6570\u9519\u8bef");
        }
    }

    public LiquidationCommonResult call(String method, Object contentObj) {
        try {
            return this.call(method, JsonUtil.getJsonByCamelPojo(contentObj));
        }
        catch (JsonProcessingException e) {
            log.error("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u65f6pojo\u9a7c\u5cf0\u8f6c\u6362\u5931\u8d25 method={};contentObj={}; ex = {}", new Object[]{method, JSON.toJSONString((Object)contentObj), ExceptionUtils.getStackTrace((Throwable)e)});
            return LiquidationCommonResult.commonError((String)"\u53c2\u6570\u9519\u8bef");
        }
    }

    public LiquidationCommonResult call(String method, String contentJson) {
        LiquidationCommonResult commonResult = new LiquidationCommonResult();
        HashMap params = Maps.newHashMap();
        params.put("app_id", LiquidationConstants.LP_APP_ID);
        params.put("method", method);
        params.put("content", contentJson);
        params.put("version", VERSION);
        String sign = null;
        String paramsJson = JSON.toJSONString((Object)params);
        try {
            sign = AlipaySignature.rsaSign((Map)params, (String)LiquidationConstants.LP_PRIVATE_KEY, (String)"utf-8");
        }
        catch (AlipayApiException e) {
            log.error("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u65f6\u52a0\u7b7e\u5931\u8d25 param={}; ex = {}", (Object)paramsJson, (Object)ExceptionUtils.getStackTrace((Throwable)e));
            return LiquidationCommonResult.commonError((String)"\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u670d\u52a1\u7b7e\u540d\u5931\u8d25!");
        }
        params.put("sign", sign);
        HashMap form = Maps.newHashMap();
        for (String s : params.keySet()) {
            form.put(s, params.get(s));
        }
        String postResult = null;
        try {
            String url = LiquidationConstants.LP_GATEWAY_URL;
            log.info("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u5f00\u59cb request >> {}, url = {}", (Object)paramsJson, (Object)url);
            postResult = RequestUtil.post(url, params);
            log.info("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u7ed3\u675f response >> {}, request >> {}", (Object)postResult, (Object)paramsJson);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u65f6\u5931\u8d25\uff1aparam={}; ex = {}", (Object)paramsJson, (Object)ExceptionUtils.getStackTrace((Throwable)e));
        }
        if (StringUtils.isBlank(postResult)) {
            return LiquidationCommonResult.commonError((String)"\u7528\u6e05\u7b97\u5e73\u53f0\u63a5\u53e3\u670d\u52a1\u5931\u8d25\uff01");
        }
        log.info("postResult >> {}", (Object)postResult);
        JSONObject jsonObject = JSON.parseObject((String)postResult);
        Boolean success = jsonObject.getBoolean("success");
        commonResult.setSuccess(success.booleanValue());
        commonResult.setErrorCode(jsonObject.getString("error_code"));
        commonResult.setErrorMessage(jsonObject.getString("error_message"));
        commonResult.setReturnValue(jsonObject.getString("return_value"));
        return commonResult;
    }
}

