/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.alibaba.fastjson.JSON;
import com.fshows.lifecircle.service.commons.service.utils.JsonUtil;
import com.fshows.lifecircle.service.commons.service.utils.ValidateResult;
import com.fshows.lifecircle.service.commons.service.utils.ValidateUtils;
import com.fshows.lifecircle.service.manager.formModels.liquidation.AlipayMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.LiquidatorMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.WechatMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.WechatMerchantSetForm;
import com.fshows.lifecircle.service.openapi.facade.domain.params.AlipayMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.LiquidatorMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantSetParam;
import com.fshows.lifecircle.service.openapi.facade.domain.result.AlipayMchAddResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.LiquidationCommonResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.LiquidationResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxMchAddResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxMchSetResult;
import com.fshows.lifecircle.service.service.CallLiquidationPlaformService;
import com.fshows.lifecircle.service.service.utils.MapUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ApiLiquidationService {
    private static final Logger log = LoggerFactory.getLogger(ApiLiquidationService.class);
    @Resource
    private CallLiquidationPlaformService callLiquidationPlaformService;

    public BizResponse<LiquidationResult> liquidatorMerchantCreate(LiquidatorMerchantCreateParam param) {
        log.info("\u6e05\u7b97\u5e73\u53f0\u5165\u9a7b\u63a5\u53e3------------start----------->> param={}", (Object)JSON.toJSONString((Object)param));
        LiquidatorMerchantCreateForm from = new LiquidatorMerchantCreateForm();
        BeanUtils.copyProperties((Object)param, (Object)from);
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError((String)validateResult.getMsg());
        }
        LiquidationCommonResult call = this.callLiquidationPlaformService.call("fshows.liquidation.merchant.create", MapUtils.java2Map(from));
        if (call.isSuccess()) {
            LiquidationResult liquidationResult = new LiquidationResult();
            BeanUtils.copyProperties((Object)call, (Object)liquidationResult);
            Map map = JsonUtil.toHashMap(call.getReturnValue());
            if (map == null || map.get("sub_merchant_id") == null) {
                return BizResponse.fail((String)call.getErrorCode(), (String)"\u5546\u6237\u5165\u9a7b\u5931\u8d25");
            }
            liquidationResult.setSubMerchantId(map.get("sub_merchant_id") + "");
            return BizResponse.success((Object)liquidationResult);
        }
        return BizResponse.fail((String)call.getErrorCode(), (String)call.getErrorMessage());
    }

    public BizResponse<AlipayMchAddResult> alipayMerchantCreate(AlipayMerchantCreateParam param) {
        log.info("\u652f\u4ed8\u5b9d\u5165\u9a7b\u63a5\u53e3------------start----------->> param={}", (Object)JSON.toJSONString((Object)param));
        AlipayMerchantCreateForm from = new AlipayMerchantCreateForm();
        BeanUtils.copyProperties((Object)param, (Object)from);
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError((String)validateResult.getMsg());
        }
        LiquidationCommonResult call = this.callLiquidationPlaformService.call("fshows.alipay.merchant.create", MapUtils.java2Map(from));
        if (call.isSuccess()) {
            AlipayMchAddResult alipayMchAddResult = new AlipayMchAddResult();
            BeanUtils.copyProperties((Object)call, (Object)alipayMchAddResult);
            return BizResponse.success((Object)alipayMchAddResult);
        }
        return BizResponse.fail((String)call.getErrorCode(), (String)call.getErrorMessage());
    }

    public BizResponse<WxMchAddResult> wechatMerchantCreate(WechatMerchantCreateParam param) {
        log.info("\u5fae\u4fe1\u5165\u9a7b\u63a5\u53e3------------start----------->> param={}", (Object)JSON.toJSONString((Object)param));
        WechatMerchantCreateForm from = new WechatMerchantCreateForm();
        BeanUtils.copyProperties((Object)param, (Object)from);
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError((String)validateResult.getMsg());
        }
        LiquidationCommonResult call = this.callLiquidationPlaformService.call("fshows.liquidation.wx.submerchant.create.supplement", MapUtils.java2Map(from));
        if (call.isSuccess()) {
            WxMchAddResult wxMchAddResult = new WxMchAddResult();
            BeanUtils.copyProperties((Object)call, (Object)wxMchAddResult);
            return BizResponse.success((Object)wxMchAddResult);
        }
        return BizResponse.fail((String)call.getErrorCode(), (String)call.getErrorMessage());
    }

    public BizResponse<WxMchSetResult> wechatSubMerchantSet(WechatMerchantSetParam param) {
        log.info("\u5fae\u4fe1\u5b50\u5546\u6237\u914d\u7f6e\u63a5\u53e3------------start----------->> param={}", (Object)JSON.toJSONString((Object)param));
        WechatMerchantSetForm from = new WechatMerchantSetForm();
        BeanUtils.copyProperties((Object)param, (Object)from);
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError((String)validateResult.getMsg());
        }
        LiquidationCommonResult call = this.callLiquidationPlaformService.call("fshows.liquidation.wx.submerchant.config.create.supplement", MapUtils.java2Map(from));
        if (call.isSuccess()) {
            WxMchSetResult wxMchSetResult = new WxMchSetResult();
            BeanUtils.copyProperties((Object)call, (Object)wxMchSetResult);
            return BizResponse.success((Object)wxMchSetResult);
        }
        return BizResponse.fail((String)call.getErrorCode(), (String)call.getErrorMessage());
    }
}

