/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.fshows.lifecircle.service.commons.service.contants.AliConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Date;
import java.util.LinkedHashMap;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSUtil {
    private static final Logger log = LoggerFactory.getLogger(AliOSSUtil.class);

    public static OSSClient getOSSClient() {
        OSSClient ossClient = new OSSClient("http://oss-cn-hangzhou.aliyuncs.com", "LTAIu1PGBk4IHE1a", "OteMAZBwVcoYoyQSQVS1necaExDeLY");
        return ossClient;
    }

    public static boolean uploadFile(String bucketName, String key, String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            File file = new File(filename);
            FileInputStream input = new FileInputStream(file);
            ossClient.putObject(bucketName, key, (InputStream)input);
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> uploadFile \u4e0a\u4f20\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            ossClient.shutdown();
            return false;
        }
    }

    public static void downloadFile(String bucketName, String key, String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            ossClient.getObject(new GetObjectRequest(bucketName, key), new File(filename));
            ossClient.shutdown();
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> downloadFile \u4e0b\u8f7d\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            ossClient.shutdown();
        }
    }

    public static String fileUrl(String bucketName, String key) {
        OSSClient ossClient = null;
        String downloadUrl = "";
        try {
            ossClient = AliOSSUtil.getOSSClient();
            java.util.Date time = new java.util.Date(System.currentTimeMillis() + 3600000L);
            URL url = ossClient.generatePresignedUrl(bucketName, key, time);
            downloadUrl = url.toString();
            ossClient.shutdown();
            return downloadUrl;
        }
        catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return downloadUrl;
        }
    }

    public static String getToken(String dirName) {
        String host = "http://" + AliConstants.ALI_CLOUD_SERVICES_BUCKET_NAME + ".oss-cn-hangzhou.aliyuncs.com";
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            Date expiration = new Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dirName);
            String postPolicy = ossClient.generatePostPolicy((java.util.Date)expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = ossClient.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", "LTAIu1PGBk4IHE1a");
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("bucketName", AliConstants.ALI_CLOUD_SERVICES_BUCKET_NAME);
            respMap.put("dir", dirName);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            JSONObject ja1 = JSONObject.fromObject(respMap);
            return ja1.toString();
        }
        catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return null;
        }
    }

    public static void main(String[] args) {
        String faceKey = "AliYun_UserId_Face.png";
        String backKey = "AliYun_UserId_Back.png";
        String holdKey = "AliYun_UserId_Hold.png";
        String fileName = "/Users/spafka/Downloads/spafka.JPG";
        String fileName2 = "/Users/spafka/Downloads/spafka2.JPG";
        System.out.println("\u51c6\u5907\u4e0a\u4f20\uff01");
        AliOSSUtil.uploadFile("services-test-images", "spafka.jpg", fileName);
        System.out.println("\u4e0a\u4f20\u5b8c\u6bd5\uff01");
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("\u51c6\u5907\u4e0b\u8f7d\uff01");
        AliOSSUtil.downloadFile("services-test-images", "spafka.jpg", fileName2);
        System.out.println("\u4e0b\u8f7d\u5b8c\u6bd5\uff01");
    }
}

