/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service.pushservices;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.fshows.lifecircle.service.commons.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.commons.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.service.contants.PushConstant;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class HvPushService {
    private static final Logger log = LoggerFactory.getLogger(HvPushService.class);
    private static final String appId = PushConstant.HV_APPID;
    private static final String apiUrl = "https://api.push.hicloud.com/pushsend.do";
    private static final String appSecret = PushConstant.HV_APPSECRET;
    private static final String tokenUrl = "https://login.vmall.com/oauth2/token";
    private static final String androidPageName = PushConstant.HV_ANDROID_PACKAGE_NAME;
    private static final String logoUrl = PushConstant.HV_LOGO_URL;
    private static final String redisKey = "SERVICE_HV_ACCESS_TOKEN";
    private static final String tokenTimeKey = "SERVICE_TOKEN_EXPIRED_TIME";
    Long redisTimeOut = 604800L;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;

    public BizResponse hvPush(ApiPushModel apiPushModel) {
        Map<String, String> data = this.getToken();
        String accessToken = data.get(redisKey);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        String deviceToken = apiPushModel.getTargetValue();
        String title = apiPushModel.getTitle();
        String text = apiPushModel.getBody();
        String actionUrl = apiPushModel.getActionUrl();
        String extendContent = apiPushModel.getExtendContent();
        Integer timeOut = apiPushModel.getTimeOut();
        Long messageId = apiPushModel.getMessageId();
        Integer actionType = apiPushModel.getActionType();
        JSONArray deviceTokens = new JSONArray();
        deviceTokens.add((Object)deviceToken);
        Integer msgType = apiPushModel.getPassThrough();
        if (0 == msgType) {
            msgType = 3;
        }
        JSONObject payload = this.encapsulationPayload(title, text, extendContent, actionType, actionUrl, msgType);
        HashMap req = Maps.newHashMap();
        try {
            String postBody = MessageFormat.format("access_token={0}&nsp_svc={1}&nsp_ts={2}&device_token_list={3}&payload={4}&expire_time{5}", URLEncoder.encode(accessToken, "UTF-8"), URLEncoder.encode("openpush.message.api.send", "UTF-8"), URLEncoder.encode(String.valueOf(System.currentTimeMillis() / 1000L), "UTF-8"), URLEncoder.encode(deviceTokens.toString(), "UTF-8"), URLEncoder.encode(payload.toString(), "UTF-8"), URLEncoder.encode(String.valueOf(System.currentTimeMillis() / 1000L + (long)timeOut.intValue()), "UTF-8"));
            String postUrl = "https://api.push.hicloud.com/pushsend.do?nsp_ctx=" + URLEncoder.encode("{\"ver\":\"1\", \"appId\":\"" + appId + "\"}", "UTF-8");
            String request = HttpUtil.post((String)postUrl, (String)postBody);
            req = JSON.parseObject((String)request);
        }
        catch (Exception e) {
            log.error("HvPush -- \u534e\u4e3a\u63a8\u9001\u5931\u8d25\uff01messageId = {}, \u539f\u56e0\uff1ae = {}", (Object)messageId, (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        String CODE = "code";
        String SUCCESSCODE = "80000000";
        String MSG = "msg";
        String SUCCESS = "SUCCESS";
        if (req.get(CODE).toString().equals(SUCCESSCODE) && req.get(MSG).toString().toUpperCase().equals(SUCCESS)) {
            this.fbAppMessageMapperExt.updateMessageByStatus(apiPushModel.getMessageId(), Integer.valueOf(1));
            return BizResponse.success((Object)req);
        }
        return BizResponse.fail((String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), (String)ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    public JSONObject encapsulationPayload(String title, String text, String extendContent, Integer actionType, String actionUrl, Integer msgType) {
        JSONObject body = new JSONObject();
        body.put("title", (Object)title);
        body.put("content", (Object)text);
        body.put("extend_content", (Object)extendContent);
        JSONObject param1 = new JSONObject();
        param1.put("appPkgName", (Object)actionUrl);
        JSONObject param2 = new JSONObject();
        param2.put("url", (Object)actionUrl);
        JSONObject param3 = new JSONObject();
        param3.put("intent", (Object)actionUrl);
        JSONObject action = new JSONObject();
        switch (actionType) {
            case 1: {
                action.put("type", (Object)3);
                action.put("param", (Object)param1);
                break;
            }
            case 2: {
                action.put("type", (Object)2);
                action.put("param", (Object)param2);
                break;
            }
            default: {
                action.put("type", (Object)1);
                action.put("param", (Object)param3);
            }
        }
        JSONObject msg = new JSONObject();
        msg.put("type", (Object)msgType);
        msg.put("action", (Object)action);
        msg.put("body", (Object)body);
        JSONObject ext = new JSONObject();
        ext.put("biTag", (Object)"Trump");
        ext.put("icon", (Object)logoUrl);
        JSONObject hps = new JSONObject();
        hps.put("msg", (Object)msg);
        hps.put("ext", (Object)ext);
        JSONObject payload = new JSONObject();
        payload.put("hps", (Object)hps);
        return payload;
    }

    public Map<String, String> getToken() {
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)redisKey);
        Map<String, String> data = (Map<String, String>)JSON.parse((String)value);
        if (StringUtils.isBlank((CharSequence)value) || StringUtils.isBlank((CharSequence)((CharSequence)data.get(redisKey))) || StringUtils.isBlank((CharSequence)data.get(tokenTimeKey))) {
            data = this.refreshToken();
            String timeOut = data.get(tokenTimeKey);
            this.redisTimeOut = Long.valueOf(timeOut) - 300L;
            log.info("redis -- set - method:getToken \u4fe1\u606f\u6536\u96c6\u5f00\u59cb  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{redisKey, JSON.toJSONString(data), this.redisTimeOut, TimeUnit.SECONDS});
            this.stringRedisTemplate.opsForValue().set((Object)redisKey, (Object)JSON.toJSONString(data), this.redisTimeOut.longValue(), TimeUnit.SECONDS);
            log.info("redis -- set - method:getToken \u4fe1\u606f\u6536\u96c6\u7ed3\u675f  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{redisKey, JSON.toJSONString(data), this.redisTimeOut, TimeUnit.SECONDS});
        }
        return data;
    }

    public Map<String, String> refreshToken() {
        HashMap data = Maps.newHashMap();
        try {
            String msgBody = MessageFormat.format("grant_type=client_credentials&client_secret={0}&client_id={1}", URLEncoder.encode(appSecret, "UTF-8"), appId);
            String response = HttpUtil.post((String)tokenUrl, (String)msgBody);
            JSONObject obj = JSONObject.parseObject((String)response);
            String accessToken = obj.getString("access_token");
            long tokenExpiredTime = obj.getLong("expires_in");
            data.put(redisKey, accessToken);
            data.put(tokenTimeKey, tokenExpiredTime + "");
        }
        catch (Exception e) {
            log.error("HvPush -- >> \u8ba4\u8bc1Token\u83b7\u53d6\u5931\u8d25\uff01\u539f\u56e0\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        return data;
    }
}

