/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.CircleCaptcha;
import cn.hutool.core.exceptions.ExceptionUtil;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.PVCSRusult;
import com.fshows.lifecircle.service.commons.service.contants.CommonConstant;
import com.fshows.lifecircle.service.commons.service.utils.RandomUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class PictureVCService {
    private static final Logger log = LoggerFactory.getLogger(PictureVCService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public BizResponse<PVCSRusult> getPVSPngCode(Integer channelType, Integer height, Integer width, Integer count) {
        int randomCode = RandomUtil.buildRandom(6);
        String token = CommonConstant.PVSCODE_REDIS_KEY + randomCode + "_" + channelType;
        String code = "";
        String imageBase64 = "";
        try {
            CircleCaptcha circleCaptcha = CaptchaUtil.createCircleCaptcha((int)width, (int)height, (int)count, (int)0);
            imageBase64 = circleCaptcha.getImageBase64();
            code = circleCaptcha.getCode();
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("PictureVCService -- >> getPVSPngCode \u6d41\u6570\u636e\u8f6c\u5316\u9519\u8bef\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
        }
        if (StringUtils.isBlank((CharSequence)code) || StringUtils.isBlank((CharSequence)imageBase64)) {
            log.error("PictureVCService -- >> getPVSPngCode \u6d41\u6570\u636e\u8f6c\u5316\u9519\u8bef\uff1atoken = {}, code = {}, imageBase64 = {}", new Object[]{token, code, imageBase64});
            return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
        }
        log.info("redis -- set - method:PVS-jpg \u4fe1\u606f\u6536\u96c6\u5f00\u59cb  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{token, code, 300, TimeUnit.SECONDS});
        this.stringRedisTemplate.opsForValue().set((Object)token, (Object)code, 300L, TimeUnit.SECONDS);
        log.info("redis -- set - method:PVS-jpg \u4fe1\u606f\u6536\u96c6\u7ed3\u675f  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{token, code, 300, TimeUnit.SECONDS});
        PVCSRusult rusult = new PVCSRusult();
        rusult.setCode(imageBase64);
        rusult.setToken(token);
        return BizResponse.success((Object)rusult);
    }

    public BizResponse<Boolean> checkCodeForChannel(Integer channelType, String token, String code) {
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        String PVCodeText = (String)this.stringRedisTemplate.opsForValue().get((Object)token);
        if (StringUtils.isBlank((CharSequence)PVCodeText)) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (PVCodeText.toUpperCase().equals(code.toUpperCase())) {
            this.stringRedisTemplate.delete((Object)token);
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}

