/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import com.fshows.lifecircle.service.commons.dao.FbKoubeiCategoryMapperExt;
import com.fshows.lifecircle.service.commons.dao.FbKoubeiWxCategoryMapperExt;
import com.fshows.lifecircle.service.commons.domain.FbKoubeiWxCategory;
import com.fshows.lifecircle.service.commons.domain.models.KoubeiCategoryModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.KoubeiDetailModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.KoubeiResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.WxKoubeiResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FbKoubeiCategoryService {
    private static final Logger log = LoggerFactory.getLogger(FbKoubeiCategoryService.class);
    @Resource
    private FbKoubeiCategoryMapperExt fbKoubeiCategoryMapperExt;
    @Resource
    private FbKoubeiWxCategoryMapperExt fbKoubeiWxCategoryMapperExt;

    public BizResponse<List<KoubeiResult>> getKoubeiCategory(String categoryId) {
        List parentCategory = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(categoryId);
        ArrayList newParentCategory = Lists.newArrayList();
        for (KoubeiCategoryModel model : parentCategory) {
            KoubeiResult result = new KoubeiResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newParentCategory.add(result);
        }
        return BizResponse.success((Object)newParentCategory);
    }

    public BizResponse<List<KoubeiResult>> getALlKoubeiCategory() {
        List parentKoubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory("");
        ArrayList koubeiResultList = Lists.newArrayList();
        for (KoubeiCategoryModel parentKoubeiCategorie : parentKoubeiCategories) {
            KoubeiResult result = new KoubeiResult();
            result.setCategoryId(parentKoubeiCategorie.getCategoryId());
            result.setParentCategoryId(parentKoubeiCategorie.getParentCategoryId());
            result.setRootCategoryId(parentKoubeiCategorie.getRootCategoryId());
            result.setName(parentKoubeiCategorie.getName());
            List koubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(parentKoubeiCategorie.getCategoryId());
            ArrayList secondKoubeiResultList = Lists.newArrayList();
            for (KoubeiCategoryModel secondKoubeiCategorie : koubeiCategories) {
                KoubeiResult secondResult = new KoubeiResult();
                secondResult.setCategoryId(secondKoubeiCategorie.getCategoryId());
                secondResult.setParentCategoryId(secondKoubeiCategorie.getParentCategoryId());
                secondResult.setRootCategoryId(secondKoubeiCategorie.getRootCategoryId());
                secondResult.setName(secondKoubeiCategorie.getName());
                List threeKoubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(secondKoubeiCategorie.getCategoryId());
                secondResult.setData(threeKoubeiCategories);
                secondKoubeiResultList.add(secondResult);
            }
            result.setData(koubeiCategories);
            koubeiResultList.add(result);
        }
        return BizResponse.success((Object)koubeiResultList);
    }

    public BizResponse<KoubeiResult> getParentAndRootCategory(String categoryId) {
        KoubeiCategoryModel categoryModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(categoryId);
        KoubeiResult koubeiResult = new KoubeiResult();
        BeanUtils.copyProperties((Object)categoryModel, (Object)koubeiResult);
        return BizResponse.success((Object)koubeiResult);
    }

    public BizResponse<WxKoubeiResult> getWxKoubei(String koubeiId) {
        WxKoubeiResult result = new WxKoubeiResult();
        FbKoubeiWxCategory fbKoubeiWxCategory = this.fbKoubeiWxCategoryMapperExt.getWxKoubei(koubeiId);
        BeanUtils.copyProperties((Object)fbKoubeiWxCategory, (Object)result);
        return BizResponse.success((Object)result);
    }

    public BizResponse<KoubeiDetailModel> getKoubeiDetail(String koubeiId) {
        KoubeiDetailModel ret = new KoubeiDetailModel();
        KoubeiCategoryModel but = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(koubeiId);
        if (StringUtils.isBlank((CharSequence)but.getParentCategoryId())) {
            ret.setLevel(Integer.valueOf(1));
            ret.setFirstId(koubeiId);
            ret.setFirstName(but.getName());
        } else if (Objects.equals(but.getParentCategoryId(), but.getRootCategoryId())) {
            ret.setLevel(Integer.valueOf(2));
            String rootID = but.getRootCategoryId();
            KoubeiCategoryModel root = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(rootID);
            ret.setFirstName(root.getName());
            ret.setFirstId(root.getCategoryId());
            ret.setSecondId(but.getCategoryId());
            ret.setSecondName(but.getName());
        } else {
            ret.setLevel(Integer.valueOf(3));
            String rootID = but.getRootCategoryId();
            KoubeiCategoryModel root = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(rootID);
            ret.setFirstName(root.getName());
            ret.setFirstId(root.getCategoryId());
            KoubeiCategoryModel pare = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(but.getParentCategoryId());
            ret.setSecondName(pare.getName());
            ret.setSecondId(pare.getCategoryId());
            ret.setThirdName(but.getName());
            ret.setThirdId(but.getCategoryId());
        }
        return BizResponse.success((Object)ret);
    }
}

