/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import com.fshows.lifecircle.service.commons.dao.FbGaodeCodeMapperExt;
import com.fshows.lifecircle.service.commons.domain.models.GaodeCodeModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.GaodeResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FbGaodeCodeService {
    private static final Logger log = LoggerFactory.getLogger(FbGaodeCodeService.class);
    @Autowired
    private FbGaodeCodeMapperExt fbGaodeCodeMapperExt;

    public BizResponse<List<GaodeResult>> getGaodeProvince(Integer level, String province, String city) {
        List provinces = this.fbGaodeCodeMapperExt.getGaode(level, province, city);
        ArrayList newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : provinces) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newProvinces.add(result);
        }
        return BizResponse.success((Object)newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeCity(Integer level, String province, String city) {
        List citys = this.fbGaodeCodeMapperExt.getGaode(level, province, city);
        ArrayList newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : citys) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newProvinces.add(result);
        }
        return BizResponse.success((Object)newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeDiscrt(Integer level, String province, String city) {
        List discrts = this.fbGaodeCodeMapperExt.getGaode(level, province, city);
        ArrayList newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : discrts) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newProvinces.add(result);
        }
        return BizResponse.success((Object)newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeAllData() {
        List provinceList = this.fbGaodeCodeMapperExt.getGaode(Integer.valueOf(0), null, null);
        if (provinceList == null || provinceList.size() <= 0) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        ArrayList provinceRusults = Lists.newArrayList();
        for (GaodeCodeModel gaodeProvince : provinceList) {
            String p = gaodeProvince.getCode();
            List cityList = this.fbGaodeCodeMapperExt.getGaode(Integer.valueOf(1), p, null);
            if (cityList == null || cityList.size() <= 0) {
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            ArrayList cityRusults = Lists.newArrayList();
            GaodeResult provinceResult = new GaodeResult();
            provinceResult.setCode(gaodeProvince.getCode());
            provinceResult.setName(gaodeProvince.getName());
            provinceResult.setProvince(gaodeProvince.getProvince());
            provinceResult.setCity(gaodeProvince.getCity());
            for (GaodeCodeModel gaodeCity : cityList) {
                String c = gaodeCity.getCode();
                List discrtList = this.fbGaodeCodeMapperExt.getGaode(Integer.valueOf(2), null, c);
                GaodeResult cityResult = new GaodeResult();
                cityResult.setCode(gaodeCity.getCode());
                cityResult.setName(gaodeCity.getName());
                cityResult.setProvince(gaodeCity.getProvince());
                cityResult.setCity(gaodeCity.getCity());
                cityResult.setData(discrtList);
                cityRusults.add(cityResult);
            }
            provinceResult.setData((List)cityRusults);
            provinceRusults.add(provinceResult);
        }
        return BizResponse.success((Object)provinceRusults);
    }
}

