/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fshows.lifecircle.service.commons.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.commons.domain.FbAppMessage;
import com.fshows.lifecircle.service.commons.domain.FbAppMessageExt;
import com.fshows.lifecircle.service.commons.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.commons.service.pushservices.AliPushService;
import com.fshows.lifecircle.service.commons.service.pushservices.GePushService;
import com.fshows.lifecircle.service.commons.service.pushservices.HvPushService;
import com.fshows.lifecircle.service.commons.service.pushservices.MiPushService;
import com.fshows.lifecircle.service.commons.service.utils.JsonUtil;
import com.fshows.lifecircle.service.commons.service.utils.ValidateResult;
import com.fshows.lifecircle.service.commons.service.utils.ValidateUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import java.util.Date;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ApiPushService {
    private static final Logger log = LoggerFactory.getLogger(ApiPushService.class);
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;
    @Autowired
    private AliPushService aliPushService;
    @Autowired
    private GePushService gePushService;
    @Autowired
    private HvPushService hvPushService;
    @Autowired
    private MiPushService miPushService;

    public BizResponse<Boolean> pushRoute(String content) {
        ApiPushModel apiPushModel = null;
        try {
            apiPushModel = JsonUtil.jsonHumpToObj(content, ApiPushModel.class);
        }
        catch (Exception e) {
            log.error("aggregationPush -- >> \u805a\u5408\u63a8\u9001\u63a5\u53e3\u9519\u8bef\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        BizResponse<Boolean> bizResponse = this.CheckValidate(apiPushModel);
        if (!((Boolean)bizResponse.getData()).booleanValue()) {
            return bizResponse;
        }
        JSONObject extentContent = JSON.parseObject((String)apiPushModel.getExtendContent());
        Map onMessage = (Map)extentContent.get("on_message");
        Map ext = (Map)onMessage.get("ext");
        if (StringUtils.isBlank((CharSequence)apiPushModel.getExtendContent()) || extentContent == null || onMessage == null || ext == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u900f\u4f20\u5b57\u6bb5\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        log.info("aggregationPush -- >> \u805a\u5408\u63a8\u9001\u63a5\u53e3\u53c2\u6570\u8bb0\u5f55\uff1aAggregationPushForm = {}", (Object)JSON.toJSONString((Object)apiPushModel));
        String orderSn = onMessage.get("order_sn").toString();
        String messageType = ext.get("message_type").toString();
        if (StringUtils.isBlank((CharSequence)orderSn)) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u65e0\u6548\u8ba2\u5355\u4fe1\u606f");
        }
        if (StringUtils.isBlank((CharSequence)messageType)) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u65e0\u6548\u6d88\u606f\u7c7b\u578b");
        }
        FbAppMessageExt record = new FbAppMessageExt();
        record.setMessage(apiPushModel.getExtendContent());
        record.setRequestId(apiPushModel.getRequestId());
        record.setMid(apiPushModel.getMid());
        record.setMessage(apiPushModel.getExtendContent());
        record.setReceiverTime(new Date());
        record.setSystemType(apiPushModel.getDeviceType());
        record.setStatus(Integer.valueOf(3));
        record.setOrderSn(orderSn);
        record.setMsgType(Integer.valueOf(messageType));
        try {
            this.fbAppMessageMapperExt.insertSelectiveForKey((FbAppMessage)record);
            apiPushModel.setMessageId(record.getId());
            ApiPushModel finalForm = apiPushModel;
            this.pushService(finalForm);
            return BizResponse.success((Object)true);
        }
        catch (Exception e) {
            log.error("aggregationPush -- >> \u63a8\u9001\u5931\u8d25\uff1aAggregationPushForm = {}, record = {}, e = {}", new Object[]{JSON.toJSONString((Object)apiPushModel), JSON.toJSONString((Object)record), ExceptionUtil.getMessage((Throwable)e)});
            return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
        }
    }

    public BizResponse<Boolean> CheckValidate(ApiPushModel apiPushModel) {
        ValidateResult validate = ValidateUtils.validate(apiPushModel);
        if (!validate.isSuccess()) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        if (apiPushModel.getNotifyType() == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"NotifyType \u65e0\u6548");
        }
        if (apiPushModel.getActionType() == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"ActionType \u65e0\u6548");
        }
        if (apiPushModel.getPassThrough() == null) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"PassThrough \u65e0\u6548");
        }
        switch (apiPushModel.getChennelId()) {
            case 0: {
                break;
            }
            case 1: {
                if (1 == apiPushModel.getDeviceType()) break;
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u4e0d\u9002\u7528IOS\u8bbe\u5907");
            }
            case 2: {
                if (1 == apiPushModel.getDeviceType()) break;
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u4e0d\u9002\u7528IOS\u8bbe\u5907");
            }
            case 3: {
                break;
            }
            default: {
                return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u672a\u77e5\u63a8\u9001\u6e20\u9053");
            }
        }
        return null;
    }

    @Async
    public void pushService(ApiPushModel apiPushModel) {
        BizResponse bizResponse;
        switch (apiPushModel.getChennelId()) {
            case 0: {
                bizResponse = this.aliPushService.aliPush(apiPushModel);
                break;
            }
            case 1: {
                bizResponse = this.miPushService.miPush(apiPushModel);
                break;
            }
            case 2: {
                bizResponse = this.hvPushService.hvPush(apiPushModel);
                break;
            }
            case 3: {
                bizResponse = this.gePushService.gtPush(apiPushModel);
                break;
            }
            default: {
                bizResponse = null;
            }
        }
        log.info("pushService --- >> \u63a8\u9001\u7ed3\u679c\u8bb0\u5f55\u65e5\u5fd7 messageId = {}, apiPushModel = {}, bizResponse = {}", new Object[]{apiPushModel.getMessageId().toString(), JSON.toJSONString((Object)apiPushModel), JSON.toJSONString((Object)bizResponse)});
    }
}

