/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import com.fshows.lifecircle.service.commons.dao.FbBankCardBinMapperExt;
import com.fshows.lifecircle.service.commons.dao.FbBankInfoMapperExt;
import com.fshows.lifecircle.service.commons.domain.FbBankCardBin;
import com.fshows.lifecircle.service.commons.domain.FbBankInfo;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankIdNameResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankInfoResult;
import com.fshows.lifecircle.service.utils.BijectionUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ApiBankService {
    private static final Logger log = LoggerFactory.getLogger(ApiBankService.class);
    @Resource
    private FbBankInfoMapperExt fbBankInfoMapperExt;
    @Resource
    private FbBankCardBinMapperExt fbBankCardBinMapperExt;

    public BizResponse<List<BankInfoResult>> getBanksByLetter(String letter) {
        List fbBankInfos = this.fbBankInfoMapperExt.getBanksByLetter(letter);
        ArrayList bankInfoResults = Lists.newArrayList();
        if (fbBankInfos != null && fbBankInfos.size() > 0) {
            for (FbBankInfo info : fbBankInfos) {
                BankInfoResult result = new BankInfoResult();
                BeanUtils.copyProperties((Object)info, (Object)result);
                bankInfoResults.add(result);
            }
        }
        return BizResponse.success((Object)bankInfoResults);
    }

    public BizResponse<BankIdNameResult> getBankIdNameResult(String bankNo) {
        for (int i = 10; i >= 2; --i) {
            String bankPrefix = bankNo.substring(0, i);
            List fbBankCardBins = this.fbBankCardBinMapperExt.getBinsByNo(bankPrefix);
            if (fbBankCardBins == null || fbBankCardBins.size() == 0) continue;
            if (fbBankCardBins.size() == 1) {
                BankIdNameResult result = new BankIdNameResult();
                result.setBankId(((FbBankCardBin)fbBankCardBins.get(0)).getBankId());
                result.setShortName(((FbBankCardBin)fbBankCardBins.get(0)).getBankName());
                FbBankInfo bankInfo = this.fbBankInfoMapperExt.selextByBankId(((FbBankCardBin)fbBankCardBins.get(0)).getBankId());
                result.setBankNo(bankInfo.getBankNo());
                return BizResponse.success((Object)result);
            }
            int cardLength = bankPrefix.length();
            List collect = fbBankCardBins.stream().filter(cardBin -> cardBin.getCardLength() == cardLength).collect(Collectors.toList());
            if (collect == null || collect.size() != 1) continue;
            BankIdNameResult result = new BankIdNameResult();
            result.setBankId(((FbBankCardBin)collect.get(0)).getBankId());
            result.setShortName(((FbBankCardBin)collect.get(0)).getBankName());
            FbBankInfo bankInfo = this.fbBankInfoMapperExt.selextByBankId(((FbBankCardBin)fbBankCardBins.get(0)).getBankId());
            result.setBankNo(bankInfo.getBankNo());
            return BizResponse.success((Object)result);
        }
        return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)ErrorCodeEnum.INVALID_PARAMETER.getMsg());
    }

    public BizResponse<List<BankInfoResult>> getBanksByFullName(String fullname) {
        List fbBankInfos = this.fbBankInfoMapperExt.getBanksByFullName(fullname);
        ArrayList bankInfoResults = Lists.newArrayList();
        if (fbBankInfos != null && fbBankInfos.size() > 0) {
            for (FbBankInfo info : fbBankInfos) {
                BankInfoResult result = new BankInfoResult();
                BeanUtils.copyProperties((Object)info, (Object)result);
                bankInfoResults.add(result);
            }
        }
        return BizResponse.success((Object)bankInfoResults);
    }

    public BizResponse<BankInfoResult> getBankInfoByBankId(Long bankId) {
        FbBankInfo ret = this.fbBankInfoMapperExt.selextByBankId(bankId);
        BankInfoResult invert = (BankInfoResult)BijectionUtils.invert((Object)ret, BankInfoResult.class);
        return BizResponse.success((Object)invert);
    }
}

