/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyuncs.dysmsapi.model.SendSmsResponse;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.service.contants.CommonConstant;
import com.fshows.lifecircle.service.commons.service.utils.AlidayuUtil;
import com.fshows.lifecircle.service.commons.service.utils.RandomUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.fastjson.JSON;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AliSmsService {
    private static final Logger log = LoggerFactory.getLogger(AliSmsService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public BizResponse<String> sendSms(String phone, String signName, String templateCode, Integer channelType, Integer timeOut) {
        Integer countOut = Integer.parseInt(CommonConstant.SMS_COUNT_TIME_OUT);
        if (timeOut == null) {
            timeOut = countOut;
        }
        int randomCode = RandomUtil.buildRandom(6);
        String token = CommonConstant.DAYUCODE_REDIS_KEY + randomCode + "_" + channelType;
        String phoneKey = CommonConstant.SMS_COUNT_PRIFIX + "" + channelType + "" + phone;
        Object count = this.stringRedisTemplate.opsForValue().get((Object)phoneKey);
        if (count == null) {
            log.info("redis -- set - method:sendSms-count \u4fe1\u606f\u6536\u96c6\u5f00\u59cb  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{phoneKey, 1, countOut, TimeUnit.MINUTES});
            this.stringRedisTemplate.opsForValue().set((Object)phoneKey, (Object)"1", (long)countOut.intValue(), TimeUnit.MINUTES);
            log.info("redis -- set - method:sendSms-count \u4fe1\u606f\u6536\u96c6\u7ed3\u675f  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{phoneKey, 1, countOut, TimeUnit.MINUTES});
        } else if (Integer.valueOf(count.toString()) < 100) {
            this.stringRedisTemplate.opsForValue().increment((Object)phoneKey, 1L);
        } else {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u5f97\u9a8c\u8bc1\u7801\u6b21\u6570\u8fbe\u5230\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        Integer code = RandomUtil.buildRandom(6);
        log.info("redis -- set - method:sendSms-smscode \u4fe1\u606f\u6536\u96c6\u5f00\u59cb  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{token, code.toString(), timeOut, TimeUnit.MINUTES});
        this.stringRedisTemplate.opsForValue().set((Object)token, (Object)code.toString(), (long)timeOut.intValue(), TimeUnit.MINUTES);
        log.info("redis -- set - method:sendSms-smscode \u4fe1\u606f\u6536\u96c6\u7ed3\u675f  \u53c2\u6570 \uff1aredisKey = {}, data = {}, redisTimeOut = {}, type = {}", new Object[]{token, code.toString(), timeOut, TimeUnit.MINUTES});
        String value = (String)this.stringRedisTemplate.opsForValue().get((Object)token);
        log.info("sms -- >> \u53d1\u9001\u77ed\u4fe1\u8bb0\u5f55 token = {}, code = {}, timeOut = {}, value = {}", new Object[]{token, code, timeOut, value});
        SendSmsResponse sendSmsResponse = null;
        try {
            sendSmsResponse = AlidayuUtil.sendSms(phone, code.toString(), signName, templateCode);
        }
        catch (Exception e) {
            log.info("sendSms -- >> \u77ed\u4fe1\u53d1\u9001\u5931\u8d25 \u53c2\u6570\uff1aphone = {}, signName = {}, templateCode = {}, e = {}", new Object[]{phone, signName, templateCode, ExceptionUtil.getMessage((Throwable)e)});
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u53d6\u5931\u8d25\uff01");
        }
        if (sendSmsResponse == null) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u53d6\u5931\u8d25\uff01");
        }
        if (sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            return BizResponse.success((Object)token);
        }
        log.info("sendSms -- >> \u77ed\u4fe1\u53d1\u9001\u5931\u8d25 \u53c2\u6570\uff1aphone = {}, signName = {}, templateCode = {}, sendSmsResponse = {}", new Object[]{phone, signName, templateCode, JSON.toJSONString((Object)sendSmsResponse)});
        return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u53d6\u5931\u8d25\uff01");
    }

    public BizResponse<Boolean> checkSmsCode(String token, String code, Integer channelType) {
        log.info("checkSmsCode -- >> \u53c2\u6570\u6536\u96c6\uff1atoken = {}, code = {}, channelType = {}", new Object[]{token, code, channelType});
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        String smsCode = (String)this.stringRedisTemplate.opsForValue().get((Object)token);
        log.info("checkSmsCode -- >> token = {}, code = {}, smsCode = {}", new Object[]{token, code, smsCode});
        if (StringUtils.isBlank((CharSequence)smsCode)) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (smsCode.toUpperCase().equals(code.toUpperCase())) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}

