/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.BankFourFactorResult;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.IdCardResult;
import com.fshows.lifecircle.service.commons.service.AliOssService;
import com.fshows.lifecircle.service.commons.service.contants.AliConstants;
import com.fshows.lifecircle.service.commons.service.utils.HttpUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AliSecurityAuthService {
    private static final Logger log = LoggerFactory.getLogger(AliSecurityAuthService.class);
    @Autowired
    private AliOssService aliOssService;

    public BizResponse<Boolean> checkIdCard(String name, String cardId) {
        String host = "http://aliyunverifyidcard.haoservice.com";
        String path = "/idcard/VerifyIdcardv2";
        String method = "GET";
        String appcode = AliConstants.ALI_AUTH_APP_CODE;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("cardNo", cardId);
        querys.put("realName", name);
        try {
            HttpResponse response = HttpUtils.doGet(host, path, method, headers, querys);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            log.info("checkIdCard -- >> \u5b9e\u540d\u8ba4\u8bc1\uff1a\u53c2\u6570\uff1aname = {}, cardId = {}, result = {}", new Object[]{name, cardId, result});
            if (StringUtils.isBlank((CharSequence)result)) {
                return BizResponse.success((Object)false);
            }
            Map map = (Map)JSON.parse((String)result);
            if (map.get("reason").toString().toUpperCase().equals("SUCCESS") || map.get("reason").equals("\u6210\u529f")) {
                Map rs = (Map)map.get("result");
                if (((Boolean)rs.get("isok")).booleanValue()) {
                    return BizResponse.success((Object)true);
                }
                return BizResponse.fail((String)ErrorCode.AUTH_ERROR.getCode(), (String)ErrorCode.AUTH_ERROR.getMsg());
            }
            return BizResponse.fail((String)ErrorCode.AUTH_ERROR.getCode(), (String)ErrorCode.AUTH_ERROR.getMsg());
        }
        catch (Exception e) {
            log.error("checkIdCard ---- >> \u5b9e\u540d\u8ba4\u8bc1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5ali\u8ba4\u8bc1\u63a5\u53e3bug, e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return BizResponse.fail((String)ErrorCode.AUTH_ERROR.getCode(), (String)ErrorCode.AUTH_ERROR.getMsg());
        }
    }

    public BizResponse<IdCardResult> checkIdCardPicture(String bucketName, String key) {
        String type = "{\\\"side\\\":\\\"face\\\"}";
        String fileName = AliConstants.IDCARD_PHOTO_DIR + key + ".jpg";
        this.aliOssService.downloadFile(bucketName, key, fileName);
        File file = new File(fileName);
        String imgBase64 = "";
        try {
            byte[] content = new byte[(int)file.length()];
            FileInputStream finputstream = new FileInputStream(file);
            finputstream.read(content);
            finputstream.close();
            imgBase64 = new String(Base64.encodeBase64((byte[])content));
        }
        catch (IOException e) {
            log.info("checkIdCardPicture -- >> \u8eab\u4efd\u8bc1\u9a8c\u8bc1\u5931\u8d25 \uff1a e = {}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
            return BizResponse.fail((String)ErrorCode.AUTH_ERROR.getCode(), (String)ErrorCode.AUTH_ERROR.getMsg());
        }
        file.delete();
        return this.sendCheckIdCard(imgBase64, type);
    }

    public BizResponse<BankFourFactorResult> checkBankFourFactor(String name, String acctPan, String certId, String phoneNum) {
        String host = "http://ali-bankcard4.showapi.com";
        String path = "/bank4";
        String method = "GET";
        String appcode = AliConstants.ALI_AUTH_APP_CODE;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("acct_name", name);
        querys.put("acct_pan", acctPan);
        querys.put("cert_id", certId);
        querys.put("cert_type", "01");
        querys.put("needBelongArea", "true");
        querys.put("phone_num", phoneNum);
        BankFourFactorResult result = new BankFourFactorResult();
        try {
            HttpResponse response = HttpUtils.doGet(host, path, method, headers, querys);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            Map bodyMap = (Map)JSON.parse((String)body);
            log.info("checkBankFourFactor -- >> \u94f6\u884c\u56db\u8981\u7d20\u6821\u9a8c\u7ed3\u679c \uff1aname = {}, acctPan = {}, certId = {}, phoneNum = {}, bodyMap = {}", new Object[]{name, acctPan, certId, phoneNum, JSON.toJSONString((Object)bodyMap)});
            if (bodyMap == null) {
                result.setIsTrue(Boolean.valueOf(false));
                result.setMsg("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff01");
                return BizResponse.success((Object)result);
            }
            Map showapiResBody = (Map)bodyMap.get("showapi_res_body");
            if (showapiResBody == null) {
                result.setIsTrue(Boolean.valueOf(false));
                result.setMsg("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff01");
                return BizResponse.success((Object)result);
            }
            if (!showapiResBody.get("code").toString().equals("0")) {
                result.setIsTrue(Boolean.valueOf(false));
                result.setMsg("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff01" + showapiResBody.get("msg").toString());
                return BizResponse.success((Object)result);
            }
            if (!showapiResBody.get("ret_code").toString().equals("0")) {
                result.setIsTrue(Boolean.valueOf(false));
                result.setMsg("\u8ba4\u8bc1\u672a\u901a\u8fc7\uff01" + showapiResBody.get("msg").toString());
                return BizResponse.success((Object)result);
            }
            result.setMsg(showapiResBody.get("msg").toString());
            result.setBelong(JSON.toJSONString(showapiResBody.get("belong")));
            result.setIsTrue(Boolean.valueOf(true));
            return BizResponse.success((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("checkBankFourFactor -- >> \u94f6\u884c\u5361\u56db\u8981\u7d20\u6821\u9a8c\u5931\u8d25\uff01\u9519\u8bef\u539f\u56e0\uff1ae = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return BizResponse.fail((String)ErrorCode.API_ERROR.getCode(), (String)ErrorCode.API_ERROR.getMsg());
        }
    }

    public BizResponse<IdCardResult> sendCheckIdCard(String imgBase64, String type) {
        String host = "https://dm-51.data.aliyun.com";
        String path = "/rest/160601/ocr/ocr_idcard.json";
        String method = "POST";
        String appcode = AliConstants.ALI_AUTH_APP_CODE;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        headers.put("Content-Type", "application/json; charset=UTF-8");
        HashMap querys = Maps.newHashMap();
        try {
            String bodys = "{\"inputs\": [{\"image\": {\"dataType\": 50,\"dataValue\": \"" + imgBase64 + "\"},\"configure\": {\"dataType\": 50,\"dataValue\": \"" + type + "\"}}]}";
            HttpResponse response = HttpUtils.doPost(host, path, method, headers, (Map<String, String>)querys, bodys);
            String body = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isBlank((CharSequence)body)) {
                return null;
            }
            JSONObject resultObj = new JSONObject((CharSequence)body);
            JSONArray outputArray = resultObj.getJSONArray((Object)"outputs");
            JSONObject output = outputArray.getJSONObject((Object)0).getJSONObject((Object)"outputValue");
            String jsonMessage = (String)output.get((Object)"dataValue");
            Map map = (Map)JSON.parse((String)jsonMessage);
            if (!((Boolean)map.get("success")).booleanValue()) {
                return null;
            }
            String name = (String)map.get("name");
            String address = (String)map.get("address");
            String num = (String)map.get("num");
            IdCardResult result = new IdCardResult();
            result.setName(name);
            result.setNum(num);
            result.setAddress(address);
            return BizResponse.success((Object)result);
        }
        catch (Exception e) {
            log.error("checkIdCardPicture \u53d1\u9001\u5f02\u5e38 e = {}", (Object)ExceptionUtil.getMessage((Throwable)e));
            return BizResponse.fail((String)ErrorCode.AUTH_ERROR.getCode(), (String)ErrorCode.AUTH_ERROR.getMsg());
        }
    }
}

