/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.commons.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.sts.model.v20150401.AssumeRoleRequest;
import com.aliyuncs.sts.model.v20150401.AssumeRoleResponse;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.AppModelResult;
import com.fshows.lifecircle.service.commons.service.utils.AliOSSUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliOssService {
    private static final Logger log = LoggerFactory.getLogger(AliOssService.class);

    public BizResponse<Boolean> uploadFile(String bucketName, String ossKey, String fileName) {
        if (AliOSSUtil.uploadFile(bucketName, ossKey, fileName)) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getCode(), (String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getMsg());
    }

    public BizResponse<Boolean> downloadFile(String bucketName, String key, String filename) {
        AliOSSUtil.downloadFile(bucketName, key, filename);
        return BizResponse.success((Object)true);
    }

    public BizResponse<String> fileUrl(String bucketName, String key) {
        String url = AliOSSUtil.fileUrl(bucketName, key);
        if (StringUtils.isNotBlank((CharSequence)url)) {
            String[] newStrs = url.split("://");
            String str = newStrs[1];
            url = "https://" + str;
        }
        return BizResponse.success((Object)url);
    }

    public BizResponse<String> getToken(Integer imageType) {
        String dirName = null;
        if (imageType == 1) {
            dirName = "logo-images/";
        }
        if (imageType == 2) {
            dirName = "head-images/";
        }
        if (imageType == 3) {
            dirName = "merchantinfo-images/";
        }
        if (imageType == 4) {
            dirName = "qrcode-images/";
        }
        if (StringUtils.isBlank((CharSequence)dirName)) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u65e0\u6548\u7684\u7167\u7247\u53c2\u6570");
        }
        return BizResponse.success((Object)AliOSSUtil.getToken(dirName));
    }

    public BizResponse<AppModelResult> getTokenForApp() {
        String data = AliOssService.ReadJson(new ClassPathResource("config.json").getAbsolutePath());
        JSONObject jsonObj = JSONObject.fromObject((Object)data);
        String accessKeyId = jsonObj.getString("AccessKeyID");
        String accessKeySecret = jsonObj.getString("AccessKeySecret");
        String roleArn = jsonObj.getString("RoleArn");
        long durationSeconds = jsonObj.getLong("TokenExpireTime");
        String policy = AliOssService.ReadJson(new ClassPathResource(jsonObj.getString("PolicyFile")).getAbsolutePath());
        String roleSessionName = "alice-001";
        ProtocolType protocolType = ProtocolType.HTTPS;
        try {
            AssumeRoleResponse stsResponse = this.assumeRole(accessKeyId, accessKeySecret, roleArn, roleSessionName, policy, protocolType, durationSeconds);
            AppModelResult result = new AppModelResult();
            result.setAk(stsResponse.getCredentials().getAccessKeyId());
            result.setSk(stsResponse.getCredentials().getAccessKeySecret());
            result.setToken(stsResponse.getCredentials().getSecurityToken());
            result.setExpiration(stsResponse.getCredentials().getExpiration());
            return BizResponse.success((Object)result);
        }
        catch (ClientException e) {
            e.printStackTrace();
            log.error("APP - OSS \u8fde\u63a5\u5f02\u5e38\uff1a \u539f\u56e0\uff1ae = {}", (Object)ExceptionUtil.stacktraceToString((Throwable)e));
            return BizResponse.fail((String)ErrorCodeEnum.SERVER_ERROR.getCode(), (String)ErrorCodeEnum.SERVER_ERROR.getMsg());
        }
    }

    private AssumeRoleResponse assumeRole(String accessKeyId, String accessKeySecret, String roleArn, String roleSessionName, String policy, ProtocolType protocolType, long durationSeconds) throws ClientException {
        String REGION_CN_HANGZHOU = "cn-hangzhou";
        String STS_API_VERSION = "2015-04-01";
        DefaultProfile profile = DefaultProfile.getProfile((String)REGION_CN_HANGZHOU, (String)accessKeyId, (String)accessKeySecret);
        DefaultAcsClient client = new DefaultAcsClient((IClientProfile)profile);
        AssumeRoleRequest request = new AssumeRoleRequest();
        request.setVersion(STS_API_VERSION);
        request.setMethod(MethodType.POST);
        request.setProtocol(protocolType);
        request.setRoleArn(roleArn);
        request.setRoleSessionName(roleSessionName);
        request.setPolicy(policy);
        request.setDurationSeconds(Long.valueOf(durationSeconds));
        AssumeRoleResponse response = (AssumeRoleResponse)client.getAcsResponse((AcsRequest)request);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String ReadJson(String path) {
        File file = new File(path);
        BufferedReader reader = null;
        StringBuffer data = new StringBuffer();
        try {
            reader = new BufferedReader(new FileReader(file));
            String temp = null;
            while ((temp = reader.readLine()) != null) {
                data.append(temp);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return data.toString();
    }
}

