/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.service.utils;

import cn.hutool.http.HttpRequest;
import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 项目：saledian-openapi
 * 包名：com.fshows.saledian.openapi.common.utils
 * 功能：基于hutool的请求工具类
 * 时间：2017-08-01 14:41
 * 作者：BuHao
 */
public class RequestUtil {

  /**
   * 超时时间
   */
  private static final int timeout = 30000;

  /**
   * post 请求
   * @param url
   * @param params
   * @return
   */
  public static String post(String url, Map<String, String> params) {

    // 封装form
    Map<String, Object> form = Maps.newHashMap();
    for (String s : params.keySet()) {

      form.put(s, params.get(s));
    }

    String body = HttpRequest.post(url).form(form).timeout(timeout).execute().body();

    return body;
  }

}
