/**
 * Copyright (c) 2016, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.api.AlipayApiException;
import com.alipay.api.internal.util.AlipaySignature;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fshows.lifecircle.service.commons.service.utils.JsonUtil;
import com.fshows.lifecircle.service.openapi.facade.domain.result.LiquidationCommonResult;
import com.fshows.lifecircle.service.service.contants.LiquidationConstants;
import com.fshows.lifecircle.service.service.utils.RequestUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * 项目：saledian-openapi
 * 包名：business
 * 功能：
 * 时间：2016-09-28 11:31
 * 作者：BuHao
 */
@Service
@Slf4j
public class CallLiquidationPlaformService {

    private static final String VERSION = "1.0";


    /**
     * 调用清算平台的接口
     */
    public LiquidationCommonResult call(String method, Map<String, Object> contentMap) {

        try {
            return call(method, JsonUtil.getJsonByCamelPojo(contentMap));
        } catch (JsonProcessingException e) {

            log.error("调用清算平台接口时pojo驼峰转换失败 method={};contentMap={}; ex = {}",
                    method, JSON.toJSONString(contentMap), ExceptionUtils.getStackTrace(e));
            return LiquidationCommonResult.commonError("参数错误");
        }
    }

    /**
     * 调用清算平台的接口
     */
    public LiquidationCommonResult call(String method, Object contentObj) {

        try {
            return call(method, JsonUtil.getJsonByCamelPojo(contentObj));
        } catch (JsonProcessingException e) {

            log.error("调用清算平台接口时pojo驼峰转换失败 method={};contentObj={}; ex = {}",
                    method, JSON.toJSONString(contentObj), ExceptionUtils.getStackTrace(e));
            return LiquidationCommonResult.commonError("参数错误");
        }
    }

    /**
     * 调用清算平台的接口
     */
    public LiquidationCommonResult call(String method, String contentJson) {
        LiquidationCommonResult commonResult = new LiquidationCommonResult();
        // 组合参数
        Map<String, String> params = Maps.newHashMap();
        params.put("app_id", LiquidationConstants.LP_APP_ID);
        params.put("method", method);
        params.put("content", contentJson);
        params.put("version", VERSION);

        // 加签
        String sign = null;
        String paramsJson = JSON.toJSONString(params);
        try {
            sign =
                    AlipaySignature
                            .rsaSign(params, LiquidationConstants.LP_PRIVATE_KEY, "utf-8");
        } catch (AlipayApiException e) {
            log.error("调用清算平台接口时加签失败 param={}; ex = {}", paramsJson, ExceptionUtils.getStackTrace(e));
            return LiquidationCommonResult.commonError("调用清算平台服务签名失败!");

        }

        // 设置签名
        params.put("sign", sign);

        // 拼接表单
        Map<String, Object> form = Maps.newHashMap();
        for (String s : params.keySet()) {

            form.put(s, params.get(s));
        }

        // 调用接口
        String postResult = null;
        try {

            String url = LiquidationConstants.LP_GATEWAY_URL;

            log.info("调用清算平台接口开始 request >> {}, url = {}", paramsJson, url);
            postResult =
                    RequestUtil.post(url, params);

            log.info("调用清算平台接口结束 response >> {}, request >> {}", postResult, paramsJson);

        } catch (Exception e) {
            log.error("调用清算平台接口时失败：param={}; ex = {}", paramsJson, ExceptionUtils.getStackTrace(e));

//            // 如果是微信刷卡
//            boolean isWxScan =
//                    LiquidatorPlatformConstants.LIQUIDATION_METHOD_WX_SCAN.equals(method);
//            if (isWxScan) {
//
//                // 连接异常后，把支付订单放到队列中
//                String out_trade_no = JSON.parseObject(contentJson).getString("out_trade_no");
//                mqService.sendPayingOrderMessage(out_trade_no);
//            }
//
//            logger
//                    .error("调用清算平台接口时失败：ex = {}， request = {}", ExceptionUtils.getStackTrace(e), contentJson);
//            return ResultModel.commonError("调用清算平台接口服务失败！");
        }

        if (StringUtils.isBlank(postResult)) {
            return LiquidationCommonResult.commonError("用清算平台接口服务失败！");

        } else {

            log.info("postResult >> {}", postResult);

            // 把返回的字符转成对象
            JSONObject jsonObject = JSON.parseObject(postResult);
            Boolean success = jsonObject.getBoolean("success");
            commonResult.setSuccess(success);
            commonResult.setErrorCode(jsonObject.getString("error_code"));
            commonResult.setErrorMessage(jsonObject.getString("error_message"));
            commonResult.setReturnValue(jsonObject.getString("return_value"));
        }

        return commonResult;
    }
}
