package com.fshows.lifecircle.service.service;

import com.alibaba.fastjson.JSON;
import com.fshows.lifecircle.service.commons.service.utils.JsonUtil;
import com.fshows.lifecircle.service.commons.service.utils.ValidateResult;
import com.fshows.lifecircle.service.commons.service.utils.ValidateUtils;
import com.fshows.lifecircle.service.manager.formModels.liquidation.AlipayMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.LiquidatorMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.WechatMerchantCreateForm;
import com.fshows.lifecircle.service.manager.formModels.liquidation.WechatMerchantSetForm;
import com.fshows.lifecircle.service.openapi.facade.domain.params.AlipayMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.LiquidatorMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantCreateParam;
import com.fshows.lifecircle.service.openapi.facade.domain.params.WechatMerchantSetParam;
import com.fshows.lifecircle.service.openapi.facade.domain.result.*;
import com.fshows.lifecircle.service.service.contants.LiquidationConstants;
import com.fshows.lifecircle.service.service.utils.MapUtils;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

@Service
@Slf4j
public class ApiLiquidationService {


    @Resource
    private CallLiquidationPlaformService callLiquidationPlaformService;


    public BizResponse<LiquidationResult> liquidatorMerchantCreate(LiquidatorMerchantCreateParam param) {
        log.info("清算平台入驻接口------------start----------->> param={}", JSON.toJSONString(param));
        LiquidatorMerchantCreateForm from = new LiquidatorMerchantCreateForm();

        BeanUtils.copyProperties(param, from);

        //参数验证
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError(validateResult.getMsg());
        }

        // 调用清算平台接口
        LiquidationCommonResult call = callLiquidationPlaformService.call(LiquidationConstants.LP_LIQUIDATION_MERCHANT_CREATE, MapUtils.java2Map(from));

        if (call.isSuccess()) {
            LiquidationResult liquidationResult = new LiquidationResult();
            BeanUtils.copyProperties(call, liquidationResult);

            Map map = JsonUtil.toHashMap(call.getReturnValue());
            if (map == null || map.get("sub_merchant_id") == null) {
                return BizResponse.fail(call.getErrorCode(), "商户入驻失败");
            }
            liquidationResult.setSubMerchantId(map.get("sub_merchant_id") + "");
            return BizResponse.success(liquidationResult);

        } else {
            return BizResponse.fail(call.getErrorCode(), call.getErrorMessage());
        }

    }


    public BizResponse<AlipayMchAddResult> alipayMerchantCreate(AlipayMerchantCreateParam param) {
        log.info("支付宝入驻接口------------start----------->> param={}", JSON.toJSONString(param));
        AlipayMerchantCreateForm from = new AlipayMerchantCreateForm();

        BeanUtils.copyProperties(param, from);

        //参数验证
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError(validateResult.getMsg());
        }

        // 调用清算平台接口
        LiquidationCommonResult call = callLiquidationPlaformService.call(LiquidationConstants.LP_ALIPAY_MERCHANT_CREATE, MapUtils.java2Map(from));
        if (call.isSuccess()) {
            AlipayMchAddResult alipayMchAddResult = new AlipayMchAddResult();
            BeanUtils.copyProperties(call, alipayMchAddResult);

            return BizResponse.success(alipayMchAddResult);

        } else {
            return BizResponse.fail(call.getErrorCode(), call.getErrorMessage());
        }
    }

    public BizResponse<WxMchAddResult> wechatMerchantCreate(WechatMerchantCreateParam param) {
        log.info("微信入驻接口------------start----------->> param={}", JSON.toJSONString(param));
        WechatMerchantCreateForm from = new WechatMerchantCreateForm();

        BeanUtils.copyProperties(param, from);

        //参数验证
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError(validateResult.getMsg());
        }

        // 调用清算平台接口
        LiquidationCommonResult call = callLiquidationPlaformService.call(LiquidationConstants.LP_WECHAT_MERCHANT_CREATE, MapUtils.java2Map(from));
        if (call.isSuccess()) {
            WxMchAddResult wxMchAddResult = new WxMchAddResult();
            BeanUtils.copyProperties(call, wxMchAddResult);

            return BizResponse.success(wxMchAddResult);

        } else {
            return BizResponse.fail(call.getErrorCode(), call.getErrorMessage());
        }
    }

    public BizResponse<WxMchSetResult> wechatSubMerchantSet(WechatMerchantSetParam param) {

        log.info("微信子商户配置接口------------start----------->> param={}", JSON.toJSONString(param));
        WechatMerchantSetForm from = new WechatMerchantSetForm();

        BeanUtils.copyProperties(param, from);

        //参数验证
        ValidateResult validateResult = ValidateUtils.validate(from);
        if (!validateResult.isSuccess()) {
            return BizResponse.paramsError(validateResult.getMsg());
        }

        // 调用清算平台接口
        LiquidationCommonResult call = callLiquidationPlaformService.call(LiquidationConstants.LP_WECHAT_MERCHANT_CONFIG_SET, MapUtils.java2Map(from));

        if (call.isSuccess()) {
            WxMchSetResult wxMchSetResult = new WxMchSetResult();
            BeanUtils.copyProperties(call, wxMchSetResult);

            return BizResponse.success(wxMchSetResult);

        } else {
            return BizResponse.fail(call.getErrorCode(), call.getErrorMessage());
        }
    }


}
