package com.fshows.lifecircle.service.commons.service.utils;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.dysmsapi.model.SendSmsRequest;
import com.aliyuncs.dysmsapi.model.SendSmsResponse;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.fshows.lifecircle.service.commons.service.contants.AliConstants;
import com.taobao.api.ApiException;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.utils
 * @description：描述:阿里大鱼短信服务Util
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
public class AlidayuUtil {

    /**
     * startClient
     * @return
     */
    public static IAcsClient getIAcsClient() {
        //设置超时时间-可自行调整
        System.setProperty("sun.net.client.defaultConnectTimeout", "10000");
        System.setProperty("sun.net.client.defaultReadTimeout", "10000");

        //初始化ascClient需要的几个参数
        final String product = "Dysmsapi";//短信API产品名称（短信产品名固定，无需修改）
        final String domain = "dysmsapi.aliyuncs.com";//短信API产品域名（接口地址固定，无需修改）

        DefaultProfile profile = DefaultProfile.getProfile("cn-hangzhou", AliConstants.ALICLOUD_APP_KEY,
                AliConstants.ALICLOUD_APP_SECRET);

        try {
            DefaultProfile.addEndpoint("cn-hangzhou", "cn-hangzhou", product, domain);
        } catch (ClientException e) {
            e.printStackTrace();
        }
        return new DefaultAcsClient(profile);
    }

    /**
     * makeSendsms
     * @param phone
     * @param code
     * @param signName
     * @param templateCode
     * @return
     * @throws ApiException
     */
    public static SendSmsResponse sendSms(String phone, String code, String signName, String templateCode) throws ApiException, ClientException {
        //组装请求对象
        SendSmsRequest request = new SendSmsRequest();
        //使用post提交
        request.setMethod(MethodType.POST);
        //必填:待发送手机号。支持以逗号分隔的形式进行批量调用，批量上限为1000个手机号码,批量调用相对于单条调用及时性稍有延迟,验证码类型的短信推荐使用单条调用的方式
        request.setPhoneNumbers(phone);
        //必填:短信签名-可在短信控制台中找到
        request.setSignName(signName);
        //必填:短信模板-可在短信控制台中找到
        request.setTemplateCode(templateCode);
        //可选:模板中的变量替换JSON串,如模板内容为"亲爱的${name},您的验证码为${code}"时,此处的值为
        //友情提示:如果JSON中需要带换行符,请参照标准的JSON协议对换行符的要求,比如短信内容中包含\r\n的情况在JSON中需要表示成\\r\\n,否则会导致JSON在服务端解析失败
        request.setTemplateParam("{\"code\":\""+ code +"\"}");
        //可选-上行短信扩展码(扩展码字段控制在7位或以下，无特殊需求用户请忽略此字段)
        //request.setSmsUpExtendCode("90997");
        //可选:outId为提供给业务方扩展字段,最终在短信回执消息中将此值带回给调用者
        //request.setOutId("yourOutId");

        //请求失败这里会抛ClientException异常
        return getIAcsClient().getAcsResponse(request);
    }
}
