package com.fshows.lifecircle.service.commons.service.pushservices;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.fshows.lifecircle.service.commons.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.commons.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.service.contants.PushConstant;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.MultiMedia;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.Style0;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.pushServices
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
@Service
@Slf4j
public class GePushService {
    private static String appId = PushConstant.GT_APPID;
    private static String appKey = PushConstant.GT_APPKEY;
    private static String masterSecret = PushConstant.GT_MASTER_SECRET;
    private static String url = PushConstant.GT_HTTP_URL;
    private static String logo = PushConstant.GT_LOGO;
    private static String logoUrl = PushConstant.GT_LOGO_URL;

    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;

    /**
     * Client Start
     *
     * @param apiPushModel
     * @return
     */
    public BizResponse gtPush(ApiPushModel apiPushModel) {
        Long messageId = apiPushModel.getMessageId();
        String title = apiPushModel.getTitle();
        String text = apiPushModel.getBody();
        String CID = apiPushModel.getTargetValue();
        Integer passThrough = apiPushModel.getPassThrough();
        Integer actionType = apiPushModel.getActionType();
        String actionUrl = apiPushModel.getActionUrl();
        String extendContent = apiPushModel.getExtendContent();
        Integer deviceType = apiPushModel.getDeviceType();
        Integer timeOut = apiPushModel.getTimeOut();

        /**
         * 执行推送
         */
        BizResponse bizResponse = startPush(messageId, title, text, CID, extendContent,
                deviceType, passThrough, actionType,
                actionUrl, timeOut);

        /**
         * 校验执行结果
         */
        IPushResult result;
        if (StringUtils.isBlank(bizResponse.getResultCode()) || !"请求成功".equals(bizResponse.getResultCode())) {
            return bizResponse;
        }
        result = (IPushResult) bizResponse.getData();

        if (result == null) {
            return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        Map<String, Object> resultMap = result.getResponse();
        String code = "result";
        String isOk = "ok";
        if (!resultMap.get(code).equals(isOk)) {
            return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        /**
         * 推送成功记录修改库中数据
         */
        fbAppMessageMapperExt.updateMessageByStatus(messageId, 1);

        return bizResponse;
    }

    /**
     * 唤醒个推Client
     *
     * @param deviceType
     * @param passThrough
     * @param actionType
     * @param actionUrl
     * @param title
     * @param text
     * @param CID
     * @param extendContent
     * @param timeOut
     * @return
     */
    public BizResponse startPush(Long messageId, String title, String text, String CID, String extendContent,
                                 Integer deviceType, Integer passThrough, Integer actionType,
                                 String actionUrl, Integer timeOut) {
        // https连接
        IGtPush push = new IGtPush(url, appKey, masterSecret);
        // 此处true为https域名，false为http，默认为false。Java语言推荐使用此方式
        // IGtPush push = new IGtPush(host, appkey, master);
        // host为域名，根据域名区分是http协议/https协议
        SingleMessage message = new SingleMessage();
        //根据透传方式组装信息
        if (0 == passThrough) {
            //状态0 通知
            if (1 == actionType) {
                //动作状态1 打开app
                NotificationTemplate notificationTemplateDemo = notificationTemplateDemo(title, text, extendContent);
                message.setData(notificationTemplateDemo);

            } else if (2 == actionType) {
                //动作状态2 打开URL
                LinkTemplate template = linkTemplateDemo(title, text, actionUrl);
                message.setData(template);
            } else {
                return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), "无效动作方式");
            }
        } else if (1 == passThrough) {
            //状态1 透传
            if (0 == actionType) {
                //动作状态3 自定义透传模式
                //区分Android & IOS
                if (1 == deviceType) {
                    //设备类型0 - Android
                    TransmissionTemplate template = transmissionTemplateDemo(extendContent);
                    message.setData(template);
                } else {
                    //设备类型1 - IOS
                    TransmissionTemplate template = getTemplate(title, text, actionUrl, extendContent);
                    message.setData(template);
                }
            } else {
                return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), "无效动作方式");
            }
        } else {
            return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), "未知透传方式");
        }


        message.setOffline(true);
        // 离线有效时间，单位为毫秒，可选
        message.setOfflineExpireTime(timeOut * 1000);

        message.setPushNetWorkType(Integer.valueOf(0)); // 可选，判断是否客户端是否wifi环境下推送，1为在WIFI环境下，0为不限制网络环境。
        Target target = new Target();
        target.setAppId(appId);
        target.setClientId(CID);

        IPushResult ret;
        try {
            ret = push.pushMessageToSingle(message, target);
        } catch (RequestException e) {
            log.error("GePushService -- >> 个推推送失败，原因：id = {}, e = {}", messageId, ExceptionUtil.getMessage(e));
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }

        return BizResponse.success(ret);
    }

    /**
     * 组装通知 - 方式：打开应用
     *
     * @param title
     * @param text
     * @param extendContent
     * @return
     */
    public static NotificationTemplate notificationTemplateDemo(String title, String text, String extendContent) {
        NotificationTemplate template = new NotificationTemplate();
        // 设置APPID与APPKEY
        template.setAppId(appId);
        template.setAppkey(appKey);
        // 透传消息设置，1为强制启动应用，客户端接收到消息后就会立即启动应用；2为等待应用启动
        template.setTransmissionType(1);
        //透传内容
        template.setTransmissionContent(extendContent);
        // 设置定时展示时间
        // template.setDuration("2015-01-16 11:40:00", "2015-01-16 12:24:00");

        Style0 style = new Style0();
        // 设置通知栏标题与内容
        style.setTitle(title);
        style.setText(text);
        // 配置通知栏图标
        style.setLogo(logo);
        // 配置通知栏网络图标
        style.setLogoUrl(logoUrl);
        // 设置通知是否响铃，震动，或者可清除
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle(style);

        return template;
    }

    /**
     * 组装通知 - 方式：打开URl
     *
     * @param title
     * @param text
     * @param actionUrl
     * @return
     */
    public static LinkTemplate linkTemplateDemo(String title, String text, String actionUrl) {
        LinkTemplate template = new LinkTemplate();
        // 设置APPID与APPKEY
        template.setAppId(appId);
        template.setAppkey(appKey);

        Style0 style = new Style0();
        // 设置通知栏标题与内容
        style.setTitle(title);
        style.setText(text);
        // 配置通知栏图标
        style.setLogo(logo);
        // 配置通知栏网络图标
        style.setLogoUrl(logoUrl);
        // 设置通知是否响铃，震动，或者可清除
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle(style);

        // 设置打开的网址地址
        template.setUrl(actionUrl);
        // 设置定时展示时间
        // template.setDuration("2015-01-16 11:40:00", "2015-01-16 12:24:00");
        return template;
    }

    /**
     * 组装透传参数推送 - AndRoid
     *
     * @param extendContent
     * @return
     */
    public static TransmissionTemplate transmissionTemplateDemo(String extendContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        // 透传消息设置，1为强制启动应用，客户端接收到消息后就会立即启动应用；2为等待应用启动
        template.setTransmissionType(2);
        template.setTransmissionContent(extendContent);
        // 设置定时展示时间
        // template.setDuration("2015-01-16 11:40:00", "2015-01-16 12:24:00");
        return template;
    }

    /**
     * 组装透传参数推送 - IOS
     *
     * @param title
     * @param text
     * @param actionUrl
     * @param extendContent
     * @return
     */
    public static TransmissionTemplate getTemplate(String title, String text, String actionUrl, String extendContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionContent(extendContent);
        template.setTransmissionType(1);
        APNPayload payload = new APNPayload();
        //在已有数字基础上加1显示，设置为-1时，在已有数字上减1显示，设置为数字时，显示指定数字
        payload.setAutoBadge("+1");
        payload.setContentAvailable(1);
        payload.setSound("default");
//        payload.setCategory("$由客户端定义");

        //简单模式APNPayload.SimpleMsg
//        payload.setAlertMsg(new APNPayload.SimpleAlertMsg(title));

//        字典模式使用APNPayload.DictionaryAlertMsg
        payload.setAlertMsg(getDictionaryAlertMsg(title, text, extendContent));

        // 添加多媒体资源
        payload.addMultiMedia(new MultiMedia().setResType(MultiMedia.MediaType.video)
                .setResUrl(actionUrl)
                .setOnlyWifi(true));

        template.setAPNInfo(payload);
        return template;
    }

    /**
     * 组装参数 - IOS 配置
     *
     * @param title
     * @param text
     * @param extendContent
     * @return
     */
    private static APNPayload.DictionaryAlertMsg getDictionaryAlertMsg(String title, String text, String extendContent) {
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setBody(text);
        alertMsg.setActionLocKey("ActionLockey");
        alertMsg.setLocKey("LocKey");
        alertMsg.addLocArg("loc-args");
        alertMsg.setLaunchImage("launch-image");
        // iOS8.2以上版本支持
        alertMsg.setTitle(title);
        alertMsg.setTitleLocKey("TitleLocKey");
        alertMsg.addTitleLocArg("TitleLocArg");
        return alertMsg;
    }
}
