package com.fshows.lifecircle.service.commons.service;

import com.fshows.lifecircle.service.commons.dao.FbGaodeCodeMapperExt;
import com.fshows.lifecircle.service.commons.domain.models.GaodeCodeModel;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.GaodeResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service
 * @description：描述:高德模块Service
 * @updateDesription：更新记录描述
 * @date：2017/11/30
 * @author：Wendy
 */
@Service
@Slf4j
public class FbGaodeCodeService {
    @Autowired
    private FbGaodeCodeMapperExt fbGaodeCodeMapperExt;

    /**
     * @author: Wendy
     * @description:获取高德地理信息
     * @date: 15:42 2017/11/30
     */
    public BizResponse<List<GaodeResult>> getGaodeProvince(Integer level, String province, String city) {
        List<GaodeCodeModel> provinces =
        fbGaodeCodeMapperExt.getGaode(level, province, city);

        List<GaodeResult> newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : provinces) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties(model, result);
            newProvinces.add(result);
        }
        return BizResponse.success(newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeCity(Integer level, String province, String city) {
        List<GaodeCodeModel> citys =
        fbGaodeCodeMapperExt.getGaode(level, province, city);

        List<GaodeResult> newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : citys) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties(model, result);
            newProvinces.add(result);
        }
        return BizResponse.success(newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeDiscrt(Integer level, String province, String city) {
        List<GaodeCodeModel> discrts =
        fbGaodeCodeMapperExt.getGaode(level, province, city);

        List<GaodeResult> newProvinces = Lists.newArrayList();
        for (GaodeCodeModel model : discrts) {
            GaodeResult result = new GaodeResult();
            BeanUtils.copyProperties(model, result);
            newProvinces.add(result);
        }
        return BizResponse.success(newProvinces);
    }

    public BizResponse<List<GaodeResult>> getGaodeAllData() {
        //获取省信息
        List<GaodeCodeModel> provinceList = fbGaodeCodeMapperExt.getGaode(0, null, null);
        if (provinceList == null || provinceList.size() <= 0) {
            return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
        }
        //包装省信息
        List<GaodeResult> provinceRusults = Lists.newArrayList();
        for (GaodeCodeModel gaodeProvince : provinceList) {
            String p = gaodeProvince.getCode();
            //获取市信息
            List<GaodeCodeModel> cityList = fbGaodeCodeMapperExt.getGaode(1, p, null);
            if (cityList == null || cityList.size() <= 0) {
                return BizResponse.fail(ErrorCodeEnum.INVALID_PARAMETER.getCode(), ErrorCodeEnum.INVALID_PARAMETER.getMsg());
            }
            //包装市信息
            List<GaodeResult> cityRusults = Lists.newArrayList();

            GaodeResult provinceResult = new GaodeResult();

            provinceResult.setCode(gaodeProvince.getCode());
            provinceResult.setName(gaodeProvince.getName());
            provinceResult.setProvince(gaodeProvince.getProvince());
            provinceResult.setCity(gaodeProvince.getCity());

            for (GaodeCodeModel gaodeCity : cityList) {
                String c = gaodeCity.getCode();
                //获取区信息
                List<GaodeCodeModel> discrtList = fbGaodeCodeMapperExt.getGaode(2, null, c);
                //包装区域信息
                GaodeResult cityResult = new GaodeResult();
                cityResult.setCode(gaodeCity.getCode());
                cityResult.setName(gaodeCity.getName());
                cityResult.setProvince(gaodeCity.getProvince());
                cityResult.setCity(gaodeCity.getCity());
                cityResult.setData(discrtList);
                cityRusults.add(cityResult);
            }
            provinceResult.setData(cityRusults);
            provinceRusults.add(provinceResult);
        }
        return BizResponse.success(provinceRusults);
    }
}
