package com.fshows.lifecircle.service.commons.service;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyuncs.dysmsapi.model.SendSmsResponse;
import com.fshows.lifecircle.service.commons.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.commons.service.utils.AlidayuUtil;
import com.fshows.lifecircle.service.commons.service.utils.RandomUtil;
import com.fshows.lifecircle.service.commons.service.contants.CommonConstant;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import java.util.concurrent.TimeUnit;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service
 * @description：描述:阿里大鱼短信
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
@Service
@Slf4j
public class AliSmsService {
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 阿里大鱼短信发送
     *
     * @param phone
     * @param signName
     * @param templateCode
     * @param channelType
     * @param timeOut
     * @return
     */
    public BizResponse<String> sendSms(String phone, String signName, String templateCode, Integer channelType, Integer timeOut) {
        Integer countOut = Integer.parseInt(CommonConstant.SMS_COUNT_TIME_OUT);
        if (timeOut == null) {
            timeOut = countOut;
        }
        //随机数
        int randomCode = RandomUtil.buildRandom(6);
        //返回标记
        String token = CommonConstant.DAYUCODE_REDIS_KEY + randomCode + "_" + channelType;
        //记录获取次数
        String phoneKey = CommonConstant.SMS_COUNT_PRIFIX + "" + channelType + "" + phone;
        //判断获取次数，写入缓存
        Object count = stringRedisTemplate.opsForValue().get(phoneKey);
        if (count == null) {
            log.info("redis -- set - method:sendSms-count 信息收集开始  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", phoneKey, 1, countOut, TimeUnit.MINUTES);
            stringRedisTemplate.opsForValue().set(phoneKey, "1", countOut, TimeUnit.MINUTES);
            log.info("redis -- set - method:sendSms-count 信息收集结束  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", phoneKey, 1, countOut, TimeUnit.MINUTES);
        } else if (Integer.valueOf(count.toString()) < 100) {
            stringRedisTemplate.opsForValue().increment(phoneKey,1L);
        } else {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), "获得验证码次数达到上限，请稍后再试");
        }

        Integer code = RandomUtil.buildRandom(6);

        //写入验证码缓存
        // TODO: 2018/1/12 log记录
        log.info("redis -- set - method:sendSms-smscode 信息收集开始  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", token, code.toString(), timeOut, TimeUnit.MINUTES);
        stringRedisTemplate.opsForValue().set(token, code.toString(), timeOut, TimeUnit.MINUTES);
        log.info("redis -- set - method:sendSms-smscode 信息收集结束  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", token, code.toString(), timeOut, TimeUnit.MINUTES);
        String value = stringRedisTemplate.opsForValue().get(token);
        log.info("sms -- >> 发送短信记录 token = {}, code = {}, timeOut = {}, value = {}", token, code, timeOut, value);

        //发短信
        SendSmsResponse sendSmsResponse = null;
        try {
            sendSmsResponse = AlidayuUtil.sendSms(phone, code.toString(), signName, templateCode);
        } catch (Exception e) {
            log.info("sendSms -- >> 短信发送失败 参数：phone = {}, signName = {}, templateCode = {}, e = {}", phone, signName, templateCode, ExceptionUtil.getMessage(e));
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), "获取失败！");
        }
        if (sendSmsResponse == null) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), "获取失败！");
        }
        if(sendSmsResponse.getCode() != null && sendSmsResponse.getCode().equals("OK")) {
            return BizResponse.success(token);
        }
        log.info("sendSms -- >> 短信发送失败 参数：phone = {}, signName = {}, templateCode = {}, sendSmsResponse = {}", phone, signName, templateCode, JSON.toJSONString(sendSmsResponse));
        return BizResponse.fail(ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), "获取失败！");

    }

    /**
     * 验证短信码
     *
     * @param token
     * @param code
     * @param channelType
     * @return
     */
    public BizResponse<Boolean> checkSmsCode(String token, String code, Integer channelType) {
        log.info("checkSmsCode -- >> 参数收集：token = {}, code = {}, channelType = {}", token, code, channelType);
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }

        String smsCode = stringRedisTemplate.opsForValue().get(token);
        log.info("checkSmsCode -- >> token = {}, code = {}, smsCode = {}", token, code, smsCode);
        if (StringUtils.isBlank(smsCode)) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }

        if (smsCode.toUpperCase().equals(code.toUpperCase())) {
            return BizResponse.success(true);
        }
        return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}
