/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.utils;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static ResourceBundle system;

    public static String getPropertiesValue(String fileName, String key) {
        try {
            ResourceBundle prop = ResourceBundle.getBundle(fileName);
            return prop.getString(key);
        }
        catch (Exception e) {
            log.error("properties file Not Found. some keys lost.");
            return null;
        }
    }

    public static String getSystem(String key) {
        String msg = null;
        try {
            msg = system.getString(key);
        }
        catch (Exception e) {
            log.error("Key['" + key + "'] Not Found in systemConfig.properties .");
        }
        return msg == null ? system.getString("default") : msg;
    }

    public static String getPropWithFilePath(String filePath, String key) {
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filePath));
            PropertyResourceBundle rb = new PropertyResourceBundle(in);
            return rb.getString(key);
        }
        catch (IOException e) {
            log.error("properties file Not Found [filePath:" + filePath + "]");
            return null;
        }
    }

    public static String getUrl(String domainKey, String path) {
        String url = "";
        try {
            url = system.getString(domainKey) + path;
        }
        catch (Exception e) {
            log.error("Key['" + domainKey + "'] Not Found in systemConfig.properties .");
        }
        return url;
    }

    public static String getUrl(String domainKey) {
        String url = "";
        try {
            url = system.getString(domainKey);
        }
        catch (Exception e) {
            log.error("Key['" + domainKey + "'] Not Found in systemConfig.properties .");
        }
        return url;
    }

    static {
        try {
            system = ResourceBundle.getBundle("application");
        }
        catch (Exception e) {
            log.error("systemConfig.properties Not Found. some keys lost.");
        }
    }
}

