/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fshows.lifecircle.service.service.utils.CamelUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class JsonUtil {
    public static String toJsonString(Object object) {
        SerializerFeature[] sf = new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty, SerializerFeature.WriteNullNumberAsZero, SerializerFeature.WriteNullListAsEmpty, SerializerFeature.WriteNullBooleanAsFalse, SerializerFeature.WriteMapNullValue};
        String text = JSON.toJSONString((Object)object, (SerializerFeature[])sf);
        return text;
    }

    public static Object toObject(String jsonText, Class clazz) {
        Object obj = JSON.parseObject((String)jsonText, (Class)clazz);
        return obj;
    }

    public static Map toMap(String text) {
        return (Map)JSON.parseObject((String)text, Map.class);
    }

    public static Map toHashMap(String text) {
        return (Map)JSON.parseObject((String)text, LinkedHashMap.class);
    }

    public static JSONObject toJsonObject(String text) {
        return (JSONObject)JSON.parse((String)text);
    }

    public static <T> T jsonHumpToObj(String humpJsonStr, Class<T> classType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        return (T)mapper.readValue(humpJsonStr, classType);
    }

    public static String toJSonByJackson(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(object);
    }

    public static String toUnderlineJSonByJackson(Object object) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        return mapper.writeValueAsString(object);
    }

    public static <T> T getObjectFromJson(String jsonStr, Class<T> valueType) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(jsonStr, valueType);
    }

    public static <T> T getObjectFromJson(String jsonStr, TypeReference<T> valueTypeRef) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (T)mapper.readValue(jsonStr, valueTypeRef);
    }

    public static String getJsonByCamelPojo(Object obj) throws JsonProcessingException {
        if (obj instanceof Map) {
            HashMap returnMap = Maps.newHashMap();
            Map pramse = (Map)obj;
            Set set = pramse.keySet();
            for (String key : set) {
                returnMap.put(CamelUtil.camelToUnderline(key), pramse.get(key));
            }
            return JSON.toJSONString((Object)returnMap);
        }
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.CAMEL_CASE_TO_LOWER_CASE_WITH_UNDERSCORES);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writeValueAsString(obj);
    }
}

