/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.pushservices;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.fshows.lifecircle.service.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.service.contants.PushConstant;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.ITemplate;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.payload.MultiMedia;
import com.gexin.rp.sdk.base.payload.Payload;
import com.gexin.rp.sdk.exceptions.RequestException;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.LinkTemplate;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.TransmissionTemplate;
import com.gexin.rp.sdk.template.style.AbstractNotifyStyle;
import com.gexin.rp.sdk.template.style.Style0;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GePushService {
    private static final Logger log = LoggerFactory.getLogger(GePushService.class);
    private static String appId = PushConstant.GT_APPID;
    private static String appKey = PushConstant.GT_APPKEY;
    private static String masterSecret = PushConstant.GT_MASTER_SECRET;
    private static String url = PushConstant.GT_HTTP_URL;
    private static String logo = PushConstant.GT_LOGO;
    private static String logoUrl = PushConstant.GT_LOGO_URL;
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;

    public BizResponse gtPush(ApiPushModel apiPushModel) {
        Integer timeOut;
        Integer deviceType;
        Long messageId = apiPushModel.getMessageId();
        String title = apiPushModel.getTitle();
        String text = apiPushModel.getBody();
        String CID = apiPushModel.getTargetValue();
        Integer passThrough = apiPushModel.getPassThrough();
        Integer actionType = apiPushModel.getActionType();
        String actionUrl = apiPushModel.getActionUrl();
        String extendContent = apiPushModel.getExtendContent();
        BizResponse bizResponse = this.startPush(messageId, title, text, CID, extendContent, deviceType = apiPushModel.getDeviceType(), passThrough, actionType, actionUrl, timeOut = apiPushModel.getTimeOut());
        if (StringUtils.isBlank((CharSequence)bizResponse.getResultCode()) || !"\u8bf7\u6c42\u6210\u529f".equals(bizResponse.getResultCode())) {
            return bizResponse;
        }
        IPushResult result = (IPushResult)bizResponse.getData();
        if (result == null) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        Map resultMap = result.getResponse();
        String code = "result";
        String isOk = "ok";
        if (!resultMap.get(code).equals(isOk)) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        this.fbAppMessageMapperExt.updateMessageByStatus(messageId, Integer.valueOf(1));
        return bizResponse;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BizResponse startPush(Long messageId, String title, String text, String CID, String extendContent, Integer deviceType, Integer passThrough, Integer actionType, String actionUrl, Integer timeOut) {
        IPushResult ret;
        LinkTemplate template;
        IGtPush push = new IGtPush(url, appKey, masterSecret);
        SingleMessage message = new SingleMessage();
        if (0 == passThrough) {
            if (1 == actionType) {
                NotificationTemplate notificationTemplateDemo = GePushService.notificationTemplateDemo(title, text, extendContent);
                message.setData((ITemplate)notificationTemplateDemo);
            } else {
                if (2 != actionType) return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u65e0\u6548\u52a8\u4f5c\u65b9\u5f0f");
                template = GePushService.linkTemplateDemo(title, text, actionUrl);
                message.setData((ITemplate)template);
            }
        } else {
            if (1 != passThrough) return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u672a\u77e5\u900f\u4f20\u65b9\u5f0f");
            if (0 != actionType) return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u65e0\u6548\u52a8\u4f5c\u65b9\u5f0f");
            if (1 == deviceType) {
                template = GePushService.transmissionTemplateDemo(extendContent);
                message.setData((ITemplate)template);
            } else {
                template = GePushService.getTemplate(title, text, actionUrl, extendContent);
                message.setData((ITemplate)template);
            }
        }
        message.setOffline(true);
        message.setOfflineExpireTime((long)(timeOut * 1000));
        message.setPushNetWorkType(Integer.valueOf(0).intValue());
        Target target = new Target();
        target.setAppId(appId);
        target.setClientId(CID);
        try {
            ret = push.pushMessageToSingle(message, target);
            return BizResponse.success((Object)ret);
        }
        catch (RequestException e) {
            log.error("GePushService -- >> \u4e2a\u63a8\u63a8\u9001\u5931\u8d25\uff0c\u539f\u56e0\uff1aid = {}, e = {}", (Object)messageId, (Object)ExceptionUtil.getMessage((Throwable)e));
            ret = push.pushMessageToSingle(message, target, e.getRequestId());
        }
        return BizResponse.success((Object)ret);
    }

    public static NotificationTemplate notificationTemplateDemo(String title, String text, String extendContent) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionType(1);
        template.setTransmissionContent(extendContent);
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(text);
        style.setLogo(logo);
        style.setLogoUrl(logoUrl);
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        return template;
    }

    public static LinkTemplate linkTemplateDemo(String title, String text, String actionUrl) {
        LinkTemplate template = new LinkTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(text);
        style.setLogo(logo);
        style.setLogoUrl(logoUrl);
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle((AbstractNotifyStyle)style);
        template.setUrl(actionUrl);
        return template;
    }

    public static TransmissionTemplate transmissionTemplateDemo(String extendContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionType(2);
        template.setTransmissionContent(extendContent);
        return template;
    }

    public static TransmissionTemplate getTemplate(String title, String text, String actionUrl, String extendContent) {
        TransmissionTemplate template = new TransmissionTemplate();
        template.setAppId(appId);
        template.setAppkey(appKey);
        template.setTransmissionContent(extendContent);
        template.setTransmissionType(1);
        APNPayload payload = new APNPayload();
        payload.setAutoBadge("+1");
        payload.setContentAvailable(1);
        payload.setSound("default");
        payload.setAlertMsg((APNPayload.AlertMsg)GePushService.getDictionaryAlertMsg(title, text, extendContent));
        payload.addMultiMedia(new MultiMedia().setResType(MultiMedia.MediaType.video).setResUrl(actionUrl).setOnlyWifi(true));
        template.setAPNInfo((Payload)payload);
        return template;
    }

    private static APNPayload.DictionaryAlertMsg getDictionaryAlertMsg(String title, String text, String extendContent) {
        APNPayload.DictionaryAlertMsg alertMsg = new APNPayload.DictionaryAlertMsg();
        alertMsg.setBody(text);
        alertMsg.setActionLocKey("ActionLockey");
        alertMsg.setLocKey("LocKey");
        alertMsg.addLocArg("loc-args");
        alertMsg.setLaunchImage("launch-image");
        alertMsg.setTitle(title);
        alertMsg.setTitleLocKey("TitleLocKey");
        alertMsg.addTitleLocArg("TitleLocArg");
        return alertMsg;
    }
}

