/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.dao.FbKoubeiCategoryMapperExt;
import com.fshows.lifecircle.service.dao.FbKoubeiWxCategoryMapperExt;
import com.fshows.lifecircle.service.domain.FbKoubeiWxCategory;
import com.fshows.lifecircle.service.domain.models.KoubeiCategoryModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.KoubeiDetailModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.KoubeiResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxKoubeiResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class FbKoubeiCategoryService {
    private static final Logger log = LoggerFactory.getLogger(FbKoubeiCategoryService.class);
    @Resource
    private FbKoubeiCategoryMapperExt fbKoubeiCategoryMapperExt;
    @Resource
    private FbKoubeiWxCategoryMapperExt fbKoubeiWxCategoryMapperExt;

    public BizResponse<List<KoubeiResult>> getKoubeiCategory(String categoryId) {
        List parentCategory = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(categoryId);
        ArrayList newParentCategory = Lists.newArrayList();
        for (KoubeiCategoryModel model : parentCategory) {
            KoubeiResult result = new KoubeiResult();
            BeanUtils.copyProperties((Object)model, (Object)result);
            newParentCategory.add(result);
        }
        return BizResponse.success((Object)newParentCategory);
    }

    public BizResponse<List<KoubeiResult>> getALlKoubeiCategory() {
        List parentKoubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory("");
        ArrayList koubeiResultList = Lists.newArrayList();
        for (KoubeiCategoryModel parentKoubeiCategorie : parentKoubeiCategories) {
            KoubeiResult result = new KoubeiResult();
            result.setCategoryId(parentKoubeiCategorie.getCategoryId());
            result.setParentCategoryId(parentKoubeiCategorie.getParentCategoryId());
            result.setRootCategoryId(parentKoubeiCategorie.getRootCategoryId());
            result.setName(parentKoubeiCategorie.getName());
            List koubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(parentKoubeiCategorie.getCategoryId());
            ArrayList secondKoubeiResultList = Lists.newArrayList();
            for (KoubeiCategoryModel secondKoubeiCategorie : koubeiCategories) {
                KoubeiResult secondResult = new KoubeiResult();
                secondResult.setCategoryId(secondKoubeiCategorie.getCategoryId());
                secondResult.setParentCategoryId(secondKoubeiCategorie.getParentCategoryId());
                secondResult.setRootCategoryId(secondKoubeiCategorie.getRootCategoryId());
                secondResult.setName(secondKoubeiCategorie.getName());
                List threeKoubeiCategories = this.fbKoubeiCategoryMapperExt.getKoubeiCategory(secondKoubeiCategorie.getCategoryId());
                secondResult.setData(threeKoubeiCategories);
                secondKoubeiResultList.add(secondResult);
            }
            result.setData(koubeiCategories);
            koubeiResultList.add(result);
        }
        return BizResponse.success((Object)koubeiResultList);
    }

    public BizResponse<KoubeiResult> getParentAndRootCategory(String categoryId) {
        KoubeiCategoryModel categoryModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(categoryId);
        KoubeiResult koubeiResult = new KoubeiResult();
        BeanUtils.copyProperties((Object)categoryModel, (Object)koubeiResult);
        return BizResponse.success((Object)koubeiResult);
    }

    public BizResponse<WxKoubeiResult> getWxKoubei(String koubeiId) {
        WxKoubeiResult result = new WxKoubeiResult();
        FbKoubeiWxCategory fbKoubeiWxCategory = this.fbKoubeiWxCategoryMapperExt.getWxKoubei(koubeiId);
        BeanUtils.copyProperties((Object)fbKoubeiWxCategory, (Object)result);
        return BizResponse.success((Object)result);
    }

    public BizResponse<KoubeiDetailModel> getKoubeiDetail(String koubeiId) {
        KoubeiDetailModel model = new KoubeiDetailModel();
        KoubeiCategoryModel CategoryModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(koubeiId);
        if (CategoryModel != null && StringUtils.isBlank((CharSequence)CategoryModel.getParentCategoryId())) {
            model.setFirstId(koubeiId);
            model.setFirstName(CategoryModel.getName());
            return BizResponse.success((Object)model);
        }
        if (CategoryModel != null && CategoryModel.getParentCategoryId().equals(CategoryModel.getRootCategoryId())) {
            KoubeiCategoryModel firstModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getParentCategoryId());
            model.setFirstId(firstModel.getCategoryId());
            model.setFirstId(firstModel.getName());
            model.setSecondId(CategoryModel.getCategoryId());
            model.setSecondName(CategoryModel.getName());
            return BizResponse.success((Object)model);
        }
        KoubeiCategoryModel firstModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getRootCategoryId());
        KoubeiCategoryModel secondModel = this.fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getParentCategoryId());
        model.setFirstId(firstModel.getCategoryId());
        model.setFirstName(firstModel.getName());
        model.setSecondId(secondModel.getCategoryId());
        model.setSecondName(secondModel.getName());
        model.setThirdId(koubeiId);
        model.setThirdName(CategoryModel.getName());
        return BizResponse.success((Object)model);
    }
}

