/**
 * Copyright (c) 2017, buh@fshows.com(BuHao) All Rights Reserved.
 */
package com.fshows.lifecircle.service.service.utils;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import lombok.experimental.UtilityClass;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * 项目：lifecircle-service-commons
 * 包名：com.fshows.lifecircle.service.utils
 * 功能：
 * 创建时间：2017-10-09 16:41
 * 更新记录：
 * @author ：BuHao
 */
@UtilityClass
public class TimeUtils {


  /**
   * 获得当前时间
   * @return
   */
  public Integer getNow() {

    return Integer.valueOf(System.currentTimeMillis() / 1000 + "");
  }

  /**
   * 获取昨日时间 yyyymmdd
   */
  public Integer getYesterday(){
    return Integer.valueOf(org.joda.time.DateTime.now().plusDays(-1).toString("yyyyMMdd"));
  }

  /**
   * 获取昨日 日初时间 yyyymmdd 00:00:00
   * @return
   */
  public Long getYesterdayStart(Integer day){
      SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
      Date date = null;
      try {
          date = simpleDateFormat.parse(day.toString());
      } catch (ParseException e) {
          e.printStackTrace();
      }
      return date.getTime()/1000;
  }

  /**
   * 解析时期字符串为时间戳
   * @param time
   * @return
   */
  public Integer parseTime(String time) {

    return Integer.valueOf(DateUtil.parse(time).getTime() / 1000 + "");
  }

  /**
   * 格式化yyyy-MM-dd HH:mm:ss时间戳
   * @param time
   * @return
   */
  public String formatTime(Integer time){

    return DateUtil.format(new DateTime(time * 1000L), "yyyy-MM-dd HH:mm:ss");
  }

  /**
   * 格式化yyyy-MM-dd时间戳
   * @param time
   * @return
   */
  public String formatDate(Integer time){

    return DateUtil.format(new DateTime(time * 1000L), "yyyy-MM-dd");

  }

  /**
   * 格式化时间戳
   * @param time
   * @param format
   * @return
   */
  public String formatDate(Integer time, String format){

    return DateUtil.format(new DateTime(time * 1000L), format);

  }

  /**
   * 获得当前时间字符串
   */
  public String getNowTimeStr() {

    return formatTime(getNow());
  }

  /**
   * 获得当前日期字符串
   */
  public String getNowDateStr() {

    return formatDate(getNow(), "yyyyMMdd");
  }
}
