package com.fshows.lifecircle.service.service.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.utils
 * @description：描述：类ResourceUtil.java的实现描述：读取properties配置文件工具类
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
public final class ResourceUtil {
    private final static Logger log = LoggerFactory.getLogger(ResourceUtil.class);

    private static ResourceBundle system;
    static {
        try {
            system = ResourceBundle.getBundle("application");
        } catch (Exception e) {
            log.error("systemConfig.properties Not Found. some keys lost.");
        }
    }

    /**
     * 获取properties配置字段value
     *
     * @param fileName
     * @param key
     * @return
     * @author TianmeiLee 2013-1-21 上午9:19:39
     */
    public static String getPropertiesValue(String fileName, String key) {

        try {
            ResourceBundle prop = ResourceBundle.getBundle(fileName);
            return prop.getString(key);
        } catch (Exception e) {
            log.error("properties file Not Found. some keys lost.");
        }
        return null;
    }

    /**
     * systemConfig
     *
     * @param key
     * @return
     */
    public static String getSystem(final String key) {
        String msg = null;
        try {
            msg = system.getString(key);
        } catch (Exception e) {
            log.error("Key['" + key + "'] Not Found in systemConfig.properties .");
        }
        return msg == null ? system.getString("default") : msg;
    }

    /**
     * 获取磁盘配置文件key-value
     *
     * @param filePath
     * @param key
     * @return
     * @author TianmeiLee 2013-9-2 上午11:37:42
     */
    public static String getPropWithFilePath(String filePath, String key) {
        try {
            InputStream in = new BufferedInputStream(new FileInputStream(filePath));
            ResourceBundle rb = new PropertyResourceBundle(in);
            return rb.getString(key);
        } catch (IOException e) {
            log.error("properties file Not Found [filePath:" + filePath + "]");
            return null;
        }
    }

    /**
     * 获取url绝对路径
     *
     * @param domainKey
     * @param path
     * @return
     */
    public static String getUrl(final String domainKey, final String path) {
        String url = "";
        try {
            url = system.getString(domainKey) + path;
        } catch (Exception e) {
            log.error("Key['" + domainKey + "'] Not Found in systemConfig.properties .");
        }
        return url;
    }

    /**
     * 获得url
     */
    public static String getUrl(final String domainKey){
        String url = "";
        try {
            url = system.getString(domainKey);
        } catch (Exception e) {
            log.error("Key['" + domainKey + "'] Not Found in systemConfig.properties .");
        }
        return url;
    }
}
