package com.fshows.lifecircle.service.service.utils;

import com.alibaba.fastjson.JSONObject;

import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.utils
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
public class CamelUtil {
    public static final char UNDERLINE = '_';

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append(UNDERLINE);
                sb.append(Character.toLowerCase(c));
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; i++) {
            char c = param.charAt(i);
            if (c == UNDERLINE) {
                if (++i < len) {
                    sb.append(Character.toUpperCase(param.charAt(i)));
                }
            } else {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    public static String underlineToCamel2(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile("_").matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - (i++);
            //String.valueOf(Character.toUpperCase(sb.charAt(position)));
            sb.replace(
                    position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }

    public static void main(String[] args) {

        JSONObject jsonObject = new JSONObject();
        jsonObject.put("my_name", "kiwi");
        jsonObject.put("myAge", "123");

        System.err.println(underlineToCamelJsonObj(jsonObject));

    }

    public static JSONObject underlineToCamelJsonObj(JSONObject jsonObject) {

        JSONObject camelJson = new JSONObject();

        Set<String> keys = jsonObject.keySet();
        for (String key : keys) {

            camelJson.put(underlineToCamel(key), getCamelOrUnderlineKey(jsonObject, key));
        }

        return camelJson;
    }

    public static Object getCamelOrUnderlineKey(JSONObject jsonObject, String camelKey) {

        Object o = jsonObject.get(camelKey);
        if (o == null) {

            o = jsonObject.get(camelToUnderline(camelKey));
        }

        return o;
    }
}
