package com.fshows.lifecircle.service.service.utils;

import cn.hutool.core.exceptions.ExceptionUtil;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.fshows.lifecircle.service.service.contants.AliConstants;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.utils
 * @description：描述:阿里OSS存储Util
 * @updateDesription：更新记录描述
 * @date：2017/12/14
 * @author：Wendy
 */
@Slf4j
public class AliOSSUtil {
    /**
     * 创建实例
     * @return
     */
    public static OSSClient getOSSClient() {
        OSSClient ossClient = new OSSClient(AliConstants.ALI_CLOUD_ENDPOINT, AliConstants.ALI_CLOUD_ACCESS_KEY_ID,
                AliConstants.ALI_CLOUD_ACCESS_KEY_SECRET);
        return ossClient;
    }

    /**
     * 上传文件
     * @param bucketName
     * @param key
     * @param filename
     * @return
     */
    public static boolean uploadFile(String bucketName, String key, String filename) {

        OSSClient ossClient = null;
        try {
            ossClient = getOSSClient();
            File file = new File(filename);
            InputStream input = new FileInputStream(file);
            ossClient.putObject(bucketName, key, input);
            //关闭OSSClient
            ossClient.shutdown();
            return true;
        } catch (Exception e) {
            log.error("AliOSSUtil ---- >> uploadFile 上传异常, e = {}", ExceptionUtil.getMessage(e));
            ossClient.shutdown();
            return false;
        }
    }

    /**
     * 下载文件
     * @param bucketName
     * @param key
     * @param filename
     */
    public static void downloadFile(String bucketName, String key, String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = getOSSClient();
            ossClient.getObject(new GetObjectRequest(bucketName, key), new File(filename));
            //关闭ossClient
            ossClient.shutdown();
        } catch (Exception e) {
            log.error("AliOSSUtil ---- >> downloadFile 下载异常, e = {}", ExceptionUtil.getMessage(e));
            ossClient.shutdown();
        }
    }

    /**
     * 生成下载url get的方式访问
     * @param bucketName
     * @param key
     * @return
     */
    public static String fileUrl(String bucketName, String key) {
        OSSClient ossClient = null;
        String downloadUrl = "";
        try {
            ossClient = getOSSClient();
            // 设置URL过期时间
            Date time = new Date(System.currentTimeMillis() + 3600 * 1000);
            // 生成URL
            URL url = ossClient.generatePresignedUrl(bucketName, key, time);
            downloadUrl = url.toString();
            //关闭ossClient
            ossClient.shutdown();
            return downloadUrl;
        } catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl 下载地址异常, e = {}", ExceptionUtil.getMessage(e));
            return downloadUrl;
        }
    }

    /**
     * ForUploadFile
     * @param dirName
     * @return
     */
    public static String getToken(String dirName) {
        String host = "http://" + AliConstants.ALI_CLOUD_SERVICES_BUCKET_NAME + "." + "oss-cn-hangzhou.aliyuncs.com";
        OSSClient ossClient = null;
        try {
            ossClient = getOSSClient();
            long expireTime = 30;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000;
            java.sql.Date expiration = new java.sql.Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem(PolicyConditions.COND_CONTENT_LENGTH_RANGE, 0, 1048576000);
            policyConds.addConditionItem(MatchMode.StartWith, PolicyConditions.COND_KEY, dirName);

            String postPolicy = ossClient.generatePostPolicy(expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String(binaryData);
            String postSignature = ossClient.calculatePostSignature(postPolicy);

            Map<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", AliConstants.ALI_CLOUD_ACCESS_KEY_ID);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("bucketName", AliConstants.ALI_CLOUD_SERVICES_BUCKET_NAME);
            respMap.put("dir", dirName);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000));
            JSONObject ja1 = JSONObject.fromObject(respMap);
            return ja1.toString();
        } catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl 下载地址异常, e = {}", ExceptionUtil.getMessage(e));
            return null;
        }
    }

    public static void main(String[] args) {
        String faceKey = "AliYun_UserId_Face.png";//正面
        String backKey = "AliYun_UserId_Back.png";//反面
        String holdKey = "AliYun_UserId_Hold.png";//手持
        String fileName = "/Users/spafka/Downloads/spafka.JPG";
        String fileName2 = "/Users/spafka/Downloads/spafka2.JPG";

        System.out.println("准备上传！");
        uploadFile("services-test-images", "spafka.jpg", fileName);
        System.out.println("上传完毕！");
        try {
            Thread.sleep(1000 * 3);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("准备下载！");
        downloadFile("services-test-images", "spafka.jpg", fileName2);
        System.out.println("下载完毕！");
//
//        System.out.println("准备下载url！");
//        String url = fileUrl(LoanConstans.ALI_CLOUD_BUCKET_NAME, key);
//        System.out.println("下载完毕！" + url);
//        System.out.println(SnUtil.createPhoneKey(1, 1));
    }
}
