package com.fshows.lifecircle.service.service.pushservices;

import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.push.model.v20160801.PushRequest;
import com.aliyuncs.push.model.v20160801.PushResponse;
import com.aliyuncs.utils.ParameterHelper;
import com.fshows.lifecircle.service.dao.FbAlipushConfigMapperExt;
import com.fshows.lifecircle.service.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.domain.FbAlipushConfig;
import com.fshows.lifecircle.service.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.gexin.fastjson.JSON;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.Map;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service.pushServices
 * @description：描述：阿里云推送Client
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
@Service
@Slf4j
public class AliPushService {
    @Autowired
    private FbAlipushConfigMapperExt tpAlipushConfigMapperExt;
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;

    /**
     * 获取阿里OEM配置封装参数准备发送
     * @param apiPushModel
     * @return
     */
    public BizResponse aliPush(ApiPushModel apiPushModel) {
        FbAlipushConfig fbAlipushConfig;
        Long oemId = 0L;
        String OEM_ID = "oem_id";
        Map<String, Object> map = (Map<String, Object>) JSON.parse(apiPushModel.getExtendContent());
        if (map != null && map.get(OEM_ID) != null && !"".equals(map.get(OEM_ID))) {
            oemId = Long.valueOf(map.get(OEM_ID).toString());
        }
        fbAlipushConfig = tpAlipushConfigMapperExt.selectByOemId(oemId);
        log.info("AliPush -- >> 阿里推送配置获取： tpAlipushConfig = {}", JSON.toJSONString(fbAlipushConfig));
        return startPush(apiPushModel, fbAlipushConfig);
    }

    /**
     * CLient Start
     * @param apiPushModel
     * @param fbAlipushConfig
     * @return
     */
    public BizResponse startPush(ApiPushModel apiPushModel, FbAlipushConfig fbAlipushConfig) {
        try {
            IClientProfile profile = DefaultProfile.getProfile(fbAlipushConfig.getAliyunRegionid(), fbAlipushConfig.getAliyunAccesskey(),
                    fbAlipushConfig.getAliyunSecretkey());
            DefaultAcsClient client = new DefaultAcsClient(profile);
            PushRequest pushRequest = new PushRequest();
            Map<String, Object> map = (Map<String, Object>) JSON.parse(apiPushModel.getExtendContent());
            String sound = "default";
            String activity = "APPLICATION";

            if (map.get("sound") != null) {
                sound.equals(map.get("sound"));
            }

            if (map.get("activity") != null) {
                activity.equals(map.get("activity"));
            }

            // 推送目标
            pushRequest.setAppKey(Long.parseLong(fbAlipushConfig.getAliyunAppkey()));
            pushRequest.setTarget("DEVICE"); //推送目标: DEVICE:按设备推送 ALIAS : 按别名推送 ACCOUNT:按帐号推送  TAG:按标签推送; ALL: 广播推送
            pushRequest.setTargetValue(apiPushModel.getTargetValue()); //根据Target来设定，如Target=DEVICE, 则对应的值为 设备id1,设备id2. 多个值使用逗号分隔.(帐号与设备有一次最多100个的限制)

            // 消息类型 MESSAGE NOTICE

            if (1 == apiPushModel.getPassThrough()) {
                apiPushModel.setBody(apiPushModel.getExtendContent());
                pushRequest.setPushType("MESSAGE");
            } else if (0 == apiPushModel.getPassThrough()) {
                pushRequest.setPushType("NOTICE");
            } else {
                return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), "未知透传方式");
            }

            // 设备类型 ANDROID iOS ALL.
            if (1 == apiPushModel.getDeviceType()) {
                pushRequest.setDeviceType("ANDROID");
            } else if (2 == apiPushModel.getDeviceType()) {
                pushRequest.setDeviceType("iOS");
            } else {
                return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), "未知设备类型");
            }

            // 推送配置
            pushRequest.setTitle(apiPushModel.getTitle()); // 消息的标题
            pushRequest.setBody(apiPushModel.getBody()); // 消息的内容
            // 推送配置: iOS
            // iOS应用图标右上角角标
            pushRequest.setIOSBadge(Integer.valueOf(1));

            // iOS通知声音
            pushRequest.setIOSMusic(sound);

            if (1 == apiPushModel.getNotifyType()) {
                pushRequest.setIOSSilentNotification(true);
            }
            pushRequest.setIOSMutableContent(true);//是否允许扩展iOS通知内容
            pushRequest.setIOSApnsEnv(fbAlipushConfig.getIosApnsEnv());//iOS的通知是通过APNs中心来发送的，需要填写对应的环境信息。"DEV" : 表示开发环境 "PRODUCT" : 表示生产环境
            pushRequest.setIOSExtParameters(apiPushModel.getExtendContent()); //通知的扩展属性(注意 : 该参数要以json map的格式传入,否则会解析出错)
            // 推送配置: Android
            pushRequest.setAndroidNotifyType("BOTH");//通知的提醒方式 "VIBRATE" : 震动 "SOUND" : 声音 "BOTH" : 声音和震动 NONE : 静音
            pushRequest.setAndroidNotificationBarType(1);//通知栏自定义样式0-100
            pushRequest.setAndroidNotificationBarPriority(1);//通知栏自定义样式0-100
            // 动作ACTION
            if (1 == apiPushModel.getActionType()) {
                pushRequest.setAndroidOpenType("APPLICATION"); //点击通知后动作 "APPLICATION" : 打开应用 "ACTIVITY" : 打开AndroidActivity "URL" : 打开URL "NONE" : 无跳转
            } else if (2 == apiPushModel.getActionType()) {
                pushRequest.setAndroidOpenType("URL");
            } else {
                pushRequest.setAndroidOpenType("NONE");
            }
            pushRequest.setAndroidOpenUrl(apiPushModel.getActionUrl()); //Android收到推送后打开对应的url,仅当AndroidOpenType="URL"有效
            pushRequest.setAndroidActivity(activity); // 设定通知打开的activity，仅当AndroidOpenType="Activity"有效
            pushRequest.setAndroidMusic("default"); // Android通知音乐
            pushRequest.setAndroidExtParameters(apiPushModel.getExtendContent()); //设定通知的扩展属性。(注意 : 该参数要以 json map 的格式传入,否则会解析出错)

            int timeOut = apiPushModel.getTimeOut(); // 超时时间(秒)
            pushRequest.setExpireTime(ParameterHelper.getISO8601Time(new Date(System.currentTimeMillis() + timeOut * 1000)));
            pushRequest.setStoreOffline(true); // 离线消息是否保存,若保存, 在推送时候，用户即使不在线，下一次上线则会收到

            PushResponse pushResponse = client.getAcsResponse(pushRequest);

            fbAppMessageMapperExt.updateMessageByStatus(apiPushModel.getMessageId(), 1);

            Map<String, Object> data = Maps.newHashMap();
            data.put("RequestId", pushResponse.getRequestId());
            data.put("MessageID", pushResponse.getMessageId());
            return BizResponse.success(data);
        } catch (Exception e) {
            return BizResponse.fail(ErrorCode.PUSH_CODE_ERROR.getCode(), e.getMessage());
        }
    }
}
