package com.fshows.lifecircle.service.service.contants;


import com.fshows.lifecircle.service.service.utils.ResourceUtil;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.openapi.contants
 * @description：描述:推送信息配置
 * @updateDesription：更新记录描述
 * @date：2017/12/11
 * @author：Wendy
 */
public interface PushConstant {

    /**
     * 小米推送配置
     */
    String MI_APPID = ResourceUtil.getSystem("mi.appid");
    String MI_APPKEY = ResourceUtil.getSystem("mi.appkey");
    String MI_APPSECRET = ResourceUtil.getSystem("mi.appsecret");
    String MI_ANDROID_PACKAGE_NAME = ResourceUtil.getSystem("mi.android.package.name");

    /**
     * 华为推送配置
     */
    String HV_APPID = ResourceUtil.getSystem("hv.appid");
    String HV_APPSECRET = ResourceUtil.getSystem("hv.appsecret");
    String HV_ANDROID_PACKAGE_NAME = ResourceUtil.getSystem("hv.android.package.name");
    String HV_TOKEN_URL= "https://login.vmall.com/oauth2/token";
    String HV_API_URL= "https://api.push.hicloud.com/pushsend.do";
    String HV_LOGO = ResourceUtil.getSystem("hv.logo");
    String HV_LOGO_URL = ResourceUtil.getSystem("hv.logo.url");
    /**
     * 个推推送配置
     */
    String GT_APPID = ResourceUtil.getSystem("gt.appid");
    String GT_APPKEY = ResourceUtil.getSystem("gt.appkey");
    String GT_APPSECRET = ResourceUtil.getSystem("gt.appsecret");
    String GT_MASTER_SECRET = ResourceUtil.getSystem("gt.mastersecret");
    String GT_ANDROID_PACKAGE_NAME = ResourceUtil.getSystem("gt.android.package.name");
    String GT_IOS_PACKAGE_NAME = ResourceUtil.getSystem("gt.ios.package.name");
    String GT_HTTP_URL = ResourceUtil.getSystem("gt.http.url");
    String GT_LOGO = ResourceUtil.getSystem("gt.logo");
    String GT_LOGO_URL = ResourceUtil.getSystem("gt.logo.url");
}
