package com.fshows.lifecircle.service.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.CircleCaptcha;
import cn.hutool.core.exceptions.ExceptionUtil;
import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.openapi.facade.domain.result.PVCSRusult;
import com.fshows.lifecircle.service.service.contants.AliConstants;
import com.fshows.lifecircle.service.service.contants.CommonConstant;
import com.fshows.lifecircle.service.service.utils.RandomUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import java.util.concurrent.TimeUnit;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service
 * @description：描述：PictureVerificationCodeService图片验证码
 * @updateDesription：更新记录描述
 * @date：2017/12/13
 * @author：Wendy
 */
@Service
@Slf4j
public class PictureVCService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    /**
     * 获取静态图片验证码（base64加密码）
     *
     * @param channelType
     * @param height
     * @param width
     * @param count
     * @return
     */
    public BizResponse<PVCSRusult> getPVSPngCode(Integer channelType, Integer height, Integer width, Integer count) {
        //随机数
        int randomCode = RandomUtil.buildRandom(6);

        //渠道类型
        String token = CommonConstant.PVSCODE_REDIS_KEY + randomCode + "_" + channelType;
        String code = "";
        String imageBase64 = "";
        try {
            CircleCaptcha circleCaptcha = CaptchaUtil.createCircleCaptcha(width, height, count, 0);
//            circleCaptcha.write(AliConstants.PVS_JPG_DIR + token + ".jpg");
            imageBase64 = circleCaptcha.getImageBase64();
            code = circleCaptcha.getCode();
        } catch (Exception e) {
            e.printStackTrace();
            log.error("PictureVCService -- >> getPVSPngCode 流数据转化错误：e = {}", ExceptionUtil.getMessage(e));
            return BizResponse.fail(ErrorCodeEnum.SERVER_ERROR.getCode(), ErrorCodeEnum.SERVER_ERROR.getMsg());
        }

        if (StringUtils.isBlank(code) || StringUtils.isBlank(imageBase64)) {
            log.error("PictureVCService -- >> getPVSPngCode 流数据转化错误：token = {}, code = {}, imageBase64 = {}", token, code, imageBase64);
            return BizResponse.fail(ErrorCodeEnum.SERVER_ERROR.getCode(), ErrorCodeEnum.SERVER_ERROR.getMsg());
        }

        /**
         * 将正确的验证码存入redis
         */
        log.info("redis -- set - method:PVS-jpg 信息收集开始  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", token, code, CommonConstant.PVSCODE_TIME_OUT, TimeUnit.SECONDS);
        stringRedisTemplate.opsForValue().set(token, code, CommonConstant.PVSCODE_TIME_OUT, TimeUnit.SECONDS);
        log.info("redis -- set - method:PVS-jpg 信息收集结束  参数 ：redisKey = {}, data = {}, redisTimeOut = {}, type = {}", token, code, CommonConstant.PVSCODE_TIME_OUT, TimeUnit.SECONDS);

        PVCSRusult rusult = new PVCSRusult();
        rusult.setCode(imageBase64);
        rusult.setToken(token);
        return BizResponse.success(rusult);
    }

    /**
     * 验证
     *
     * @param channelType
     * @param token
     * @param code
     * @return
     */
    public BizResponse<Boolean> checkCodeForChannel(Integer channelType, String token, String code) {
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }

        String PVCodeText = stringRedisTemplate.opsForValue().get(token);
        if (StringUtils.isBlank(PVCodeText)) {
            return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }

        if (PVCodeText.toUpperCase().equals(code.toUpperCase())) {
            stringRedisTemplate.delete(token);
            return BizResponse.success(true);
        }
        return BizResponse.fail(ErrorCode.VERIFICATION_CODE_ERROR.getCode(), ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}
