package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.dao.FbKoubeiCategoryMapperExt;
import com.fshows.lifecircle.service.dao.FbKoubeiWxCategoryMapperExt;
import com.fshows.lifecircle.service.domain.FbKoubeiWxCategory;
import com.fshows.lifecircle.service.domain.models.KoubeiCategoryModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.KoubeiDetailModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.KoubeiResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.WxKoubeiResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service
 * @description：描述
 * @updateDesription：更新记录描述
 * @date：2017/12/4
 * @author：Wendy
 */
@Service
@Slf4j
public class FbKoubeiCategoryService {

    @Resource
    private FbKoubeiCategoryMapperExt fbKoubeiCategoryMapperExt;

    @Resource
    private FbKoubeiWxCategoryMapperExt fbKoubeiWxCategoryMapperExt;
    /**
     * @author: Wendy
     * @description: 获取口碑类名
     * @date: 9:50 2017/12/4
     */
    public BizResponse<List<KoubeiResult>> getKoubeiCategory(String categoryId) {
        List<KoubeiCategoryModel> parentCategory =
        fbKoubeiCategoryMapperExt.getKoubeiCategory(categoryId);

        List<KoubeiResult> newParentCategory = Lists.newArrayList();

        for (KoubeiCategoryModel model : parentCategory) {
            KoubeiResult result = new KoubeiResult();
            BeanUtils.copyProperties(model, result);
            newParentCategory.add(result);
        }
        return BizResponse.success(newParentCategory);
    }

    /**
     * @author: Wendy
     * @description:获取全类目内容
     * @date: 16:52 2018/1/5
     */
    public BizResponse<List<KoubeiResult>> getALlKoubeiCategory() {
        //获取一级类
        List<KoubeiCategoryModel> parentKoubeiCategories = fbKoubeiCategoryMapperExt.getKoubeiCategory("");

        //创建新的一级类
        List<KoubeiResult> koubeiResultList = Lists.newArrayList();

        for (KoubeiCategoryModel parentKoubeiCategorie : parentKoubeiCategories) {
            KoubeiResult result = new KoubeiResult();
            result.setCategoryId(parentKoubeiCategorie.getCategoryId());
            result.setParentCategoryId(parentKoubeiCategorie.getParentCategoryId());
            result.setRootCategoryId(parentKoubeiCategorie.getRootCategoryId());
            result.setName(parentKoubeiCategorie.getName());
            //获取二级类目内容
            List<KoubeiCategoryModel> koubeiCategories = fbKoubeiCategoryMapperExt.getKoubeiCategory(parentKoubeiCategorie.getCategoryId());
                //创建新的二级类
                List<KoubeiResult> secondKoubeiResultList = Lists.newArrayList();

                    for (KoubeiCategoryModel secondKoubeiCategorie : koubeiCategories) {
                        KoubeiResult secondResult = new KoubeiResult();
                        secondResult.setCategoryId(secondKoubeiCategorie.getCategoryId());
                        secondResult.setParentCategoryId(secondKoubeiCategorie.getParentCategoryId());
                        secondResult.setRootCategoryId(secondKoubeiCategorie.getRootCategoryId());
                        secondResult.setName(secondKoubeiCategorie.getName());
                        //获取三级类目内容
                        List<KoubeiCategoryModel> threeKoubeiCategories = fbKoubeiCategoryMapperExt.getKoubeiCategory(secondKoubeiCategorie.getCategoryId());
                        secondResult.setData(threeKoubeiCategories);
                        secondKoubeiResultList.add(secondResult);
                    }

            result.setData(koubeiCategories);
            koubeiResultList.add(result);
        }
        return BizResponse.success(koubeiResultList);
    }

    public BizResponse<KoubeiResult> getParentAndRootCategory(String categoryId) {

        KoubeiCategoryModel categoryModel=  fbKoubeiCategoryMapperExt.getParentAndRootCategory(categoryId);
        KoubeiResult koubeiResult = new KoubeiResult();
        BeanUtils.copyProperties(categoryModel,koubeiResult);

        return BizResponse.success(koubeiResult);

    }

    /**
     * 对应微信口碑
     * @param koubeiId
     * @return
     */
    public BizResponse<WxKoubeiResult> getWxKoubei(String koubeiId) {
        WxKoubeiResult result = new WxKoubeiResult();
        FbKoubeiWxCategory fbKoubeiWxCategory = fbKoubeiWxCategoryMapperExt.getWxKoubei(koubeiId);
        BeanUtils.copyProperties(fbKoubeiWxCategory, result);
        return BizResponse.success(result);
    }

    /**
     * 根据口碑id获取详情
     * @param koubeiId
     * @return
     */
    public BizResponse<KoubeiDetailModel> getKoubeiDetail(String koubeiId) {
        KoubeiDetailModel model = new KoubeiDetailModel();
        KoubeiCategoryModel CategoryModel = fbKoubeiCategoryMapperExt.getParentAndRootCategory(koubeiId);
        //判断类目级别

        //一级类目
        if (CategoryModel != null && StringUtils.isBlank(CategoryModel.getParentCategoryId())) {
            model.setFirstId(koubeiId);
            model.setFirstName(CategoryModel.getName());
            return BizResponse.success(model);
        }

        //二级类目
        if (CategoryModel != null && CategoryModel.getParentCategoryId().equals(CategoryModel.getRootCategoryId())) {
            KoubeiCategoryModel firstModel = fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getParentCategoryId());
            model.setFirstId(firstModel.getCategoryId());
            model.setFirstId(firstModel.getName());
            model.setSecondId(CategoryModel.getCategoryId());
            model.setSecondName(CategoryModel.getName());
            return BizResponse.success(model);
        }

        //三级类
        KoubeiCategoryModel firstModel = fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getRootCategoryId());
        KoubeiCategoryModel secondModel = fbKoubeiCategoryMapperExt.getParentAndRootCategory(CategoryModel.getParentCategoryId());
        model.setFirstId(firstModel.getCategoryId());
        model.setFirstName(firstModel.getName());
        model.setSecondId(secondModel.getCategoryId());
        model.setSecondName(secondModel.getName());
        model.setThirdId(koubeiId);
        model.setThirdName(CategoryModel.getName());
        return BizResponse.success(model);
    }
}
