package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.dao.FbBankCardBinMapperExt;
import com.fshows.lifecircle.service.dao.FbBankInfoMapperExt;
import com.fshows.lifecircle.service.domain.FbBankCardBin;
import com.fshows.lifecircle.service.domain.FbBankInfo;
import com.fshows.lifecircle.service.openapi.facade.domain.result.BankIdNameResult;
import com.fshows.lifecircle.service.openapi.facade.domain.result.BankInfoResult;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @user：52331
 * @packageName：com.fshows.lifecircle.service.service
 * @description：描述:关于银行卡的Service
 * @updateDesription：更新记录描述
 * @date：2018/1/18
 * @author：Wendy
 */
@Service
@Slf4j
public class ApiBankService {

    @Resource
    private FbBankInfoMapperExt fbBankInfoMapperExt;

    @Resource
    private FbBankCardBinMapperExt fbBankCardBinMapperExt;

    /**
     * 根据字母获取银行信息
     * @param letter
     * @return
     */
    public BizResponse<List<BankInfoResult>> getBanksByLetter(String letter) {
        List<FbBankInfo> fbBankInfos = fbBankInfoMapperExt.getBanksByLetter(letter);
        List<BankInfoResult> bankInfoResults = Lists.newArrayList();
        if (fbBankInfos != null && fbBankInfos.size() > 0) {
            for (FbBankInfo info : fbBankInfos) {
                BankInfoResult result = new BankInfoResult();
                BeanUtils.copyProperties(info, result);
                bankInfoResults.add(result);
            }
        }
        return BizResponse.success(bankInfoResults);
    }

    /**
     * getBankIdNameResult
     * @param bankNo
     * @return
     */
    public BizResponse<BankIdNameResult> getBankIdNameResult(String bankNo) {
        for (int i = 10; i >= 2; i--) {
            //获取前缀
            String bankPrefix = bankNo.substring(0, i);
            //查询bank bin表
            List<FbBankCardBin> fbBankCardBins = fbBankCardBinMapperExt.getBinsByNo(bankPrefix);
            if (fbBankCardBins != null && fbBankCardBins.size() != 0) {
                if (fbBankCardBins.size() == 1) {
                    BankIdNameResult result = new BankIdNameResult();
                    result.setBankId(fbBankCardBins.get(0).getBankId());
                    result.setBankName(fbBankCardBins.get(0).getBankName());
                    return BizResponse.success(result);
                } else {
                    // 如果匹配到多个就再匹配银行卡长度
                    int cardLength = bankPrefix.length();
                    // 获得匹配到银行卡长度的 bin 记录
                    List<FbBankCardBin> collect = fbBankCardBins.stream()
                            .filter(cardBin -> cardBin.getCardLength() == cardLength).collect(
                                    Collectors.toList());
                    // 如果只有一个匹配的就返回
                    if (collect != null && collect.size() ==1) {
                        BankIdNameResult result = new BankIdNameResult();
                        result.setBankId(collect.get(0).getBankId());
                        result.setBankName(collect.get(0).getBankName());
                        return BizResponse.success(result);
                    }
                }
            }
        }
        return BizResponse.fail(ErrorCodeEnum.DATA_OPERATION_FAILURE.getCode(), ErrorCodeEnum.DATA_OPERATION_FAILURE.getMsg());
    }

    public BizResponse<List<BankInfoResult>> getBanksByFullName(String fullname) {

        List<FbBankInfo> fbBankInfos = fbBankInfoMapperExt.getBanksByFullName(fullname);
        List<BankInfoResult> bankInfoResults = Lists.newArrayList();
        if (fbBankInfos != null && fbBankInfos.size() > 0) {
            for (FbBankInfo info : fbBankInfos) {
                BankInfoResult result = new BankInfoResult();
                BeanUtils.copyProperties(info, result);
                bankInfoResults.add(result);
            }
        }

        return BizResponse.success(bankInfoResults);
    }
}
