/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CamelUtil {
    public static final char UNDERLINE = '_';

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_');
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel2(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        StringBuilder sb = new StringBuilder(param);
        Matcher mc = Pattern.compile("_").matcher(param);
        int i = 0;
        while (mc.find()) {
            int position = mc.end() - i++;
            sb.replace(position - 1, position + 1, sb.substring(position, position + 1).toUpperCase());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("my_name", (Object)"kiwi");
        jsonObject.put("myAge", (Object)"123");
        System.err.println(CamelUtil.underlineToCamelJsonObj(jsonObject));
    }

    public static JSONObject underlineToCamelJsonObj(JSONObject jsonObject) {
        JSONObject camelJson = new JSONObject();
        Set keys = jsonObject.keySet();
        for (String key : keys) {
            camelJson.put(CamelUtil.underlineToCamel(key), CamelUtil.getCamelOrUnderlineKey(jsonObject, key));
        }
        return camelJson;
    }

    public static Object getCamelOrUnderlineKey(JSONObject jsonObject, String camelKey) {
        Object o = jsonObject.get((Object)camelKey);
        if (o == null) {
            o = jsonObject.get((Object)CamelUtil.camelToUnderline(camelKey));
        }
        return o;
    }
}

