/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.pushservices;

import com.alibaba.fastjson.JSON;
import com.fshows.lifecircle.service.dao.FbAppMessageMapperExt;
import com.fshows.lifecircle.service.manager.formModels.ApiPushModel;
import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.service.contants.PushConstant;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.google.common.collect.Maps;
import com.xiaoleilu.hutool.exceptions.ExceptionUtil;
import com.xiaomi.xmpush.server.Constants;
import com.xiaomi.xmpush.server.Message;
import com.xiaomi.xmpush.server.Result;
import com.xiaomi.xmpush.server.Sender;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MiPushService {
    private static final Logger log = LoggerFactory.getLogger(MiPushService.class);
    @Autowired
    private FbAppMessageMapperExt fbAppMessageMapperExt;
    private static final int RETRIES = 0;

    public BizResponse miPush(ApiPushModel apiPushModel) {
        Long messageId = apiPushModel.getMessageId();
        String title = apiPushModel.getTitle();
        String description = apiPushModel.getDescription();
        Integer passThrough = apiPushModel.getPassThrough();
        Integer notifyType = apiPushModel.getNotifyType();
        Integer actionType = apiPushModel.getActionType();
        String actionUrl = apiPushModel.getActionUrl();
        String extendContent = apiPushModel.getExtendContent();
        Integer timeOut = apiPushModel.getTimeOut();
        if (StringUtils.isBlank((CharSequence)title) || title.length() > 16) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u5c0f\u7c73\u63a8\u9001\u6807\u9898\u9650\u523616\u5b57\u7b26\u4ee5\u5185");
        }
        if (StringUtils.isBlank((CharSequence)description)) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)"\u5c0f\u7c73\u63a8\u9001\u63cf\u8ff0\u4e0d\u53ef\u4ee5\u4e3a\u7a7a");
        }
        String messagePayload = apiPushModel.getBody();
        String regId = apiPushModel.getTargetValue();
        Result result = null;
        try {
            result = this.sendMessageToRegId(messageId, title, description, messagePayload, passThrough, actionType, actionUrl, notifyType, extendContent, regId, timeOut);
        }
        catch (Exception e) {
            log.error("MiPush -- >> \u63a8\u9001\u5931\u8d25 messageId = {}, \u539f\u56e0\uff1ae = {}", (Object)messageId, (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        if (result == null) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)ErrorCode.PUSH_CODE_ERROR.getMsg());
        }
        com.xiaomi.push.sdk.ErrorCode errorMessage = result.getErrorCode();
        String platformMessageId = result.getMessageId();
        String reason = result.getReason();
        if (StringUtils.isBlank((CharSequence)reason) && StringUtils.isNotBlank((CharSequence)platformMessageId)) {
            this.fbAppMessageMapperExt.updateMessageByStatus(apiPushModel.getMessageId(), Integer.valueOf(1));
            HashMap data = Maps.newHashMap();
            data.put("messageId", messageId);
            data.put("result", result);
            return BizResponse.success((Object)data);
        }
        if (StringUtils.isBlank((CharSequence)platformMessageId)) {
            return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)JSON.toJSONString((Object)result));
        }
        return BizResponse.fail((String)ErrorCode.PUSH_CODE_ERROR.getCode(), (String)JSON.toJSONString((Object)result));
    }

    private Result sendMessageToRegId(Long messageId, String title, String description, String messagePayload, Integer passThrough, Integer actionType, String actionUrl, Integer notifyType, String extendContent, String regId, Integer timeOut) {
        Constants.useOfficial();
        Sender sender = new Sender(PushConstant.MI_APPSECRET);
        Message message = this.buildMessageForAndroid(title, description, messagePayload, passThrough, actionType, actionUrl, notifyType, extendContent, timeOut);
        if (message == null || sender == null) {
            log.error("MiPush ---- >> \u5c0f\u7c73\u63a8\u9001\u5931\u8d25 \u539f\u56e0\uff1a\u53c2\u6570\u62fc\u88c5\u5931\u8d25 messageId = {}, message = null, sender = null", (Object)messageId);
        }
        Result result = null;
        try {
            result = sender.send(message, regId, 0);
        }
        catch (Exception e) {
            log.error("MiPush ---- >> \u5c0f\u7c73\u63a8\u9001\u5931\u8d25 \u539f\u56e0\uff1a\u63a8\u9001\u5931\u8d25 messageId = {}, e = {}", (Object)messageId, (Object)ExceptionUtil.getMessage((Throwable)e));
        }
        return result;
    }

    private Message buildMessageForAndroid(String title, String description, String messagePayload, Integer passThrough, Integer actionType, String actionUrl, Integer notifyType, String extendContent, Integer timeOut) {
        Message.Builder builder = new Message.Builder().title(title).description(description).payload(messagePayload).restrictedPackageName(PushConstant.MI_ANDROID_PACKAGE_NAME).passThrough(passThrough.intValue()).notifyType(notifyType).timeToLive((long)(timeOut * 1000)).extra("extend_content", extendContent);
        if (Integer.valueOf(1).equals(actionType)) {
            builder.extra("notify_effect", "2").extra("intent_uri", actionUrl);
        } else if (Integer.valueOf(2).equals(actionType)) {
            builder.extra("notify_effect", "3").extra("web_uri", actionUrl);
        } else {
            builder.extra("notify_effect", "1");
        }
        Message message = builder.build();
        return message;
    }
}

