/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.openapi.facade.domain.result.ErrorCode;
import com.fshows.lifecircle.service.service.contants.CommonConstant;
import com.fshows.lifecircle.service.service.utils.AlidayuUtil;
import com.fshows.lifecircle.service.service.utils.RandomUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.taobao.api.ApiException;
import com.taobao.api.response.AlibabaAliqinFcSmsNumSendResponse;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class AliSmsService {
    private static final Logger log = LoggerFactory.getLogger(AliSmsService.class);
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public BizResponse<String> sendSms(String extend, String phone, String signName, String templateCode, Integer channelType, Integer timeOut) {
        Integer countOut = Integer.parseInt(CommonConstant.SMS_COUNT_TIME_OUT);
        if (timeOut == null) {
            timeOut = 1;
        }
        int randomCode = RandomUtil.buildRandom(6);
        String token = CommonConstant.DAYUCODE_REDIS_KEY + randomCode + "_" + channelType;
        String phoneKey = CommonConstant.SMS_COUNT_PRIFIX + "" + channelType + "" + phone;
        Object count = this.stringRedisTemplate.opsForValue().get((Object)(CommonConstant.SMS_COUNT_PRIFIX + phone));
        if (count == null) {
            this.stringRedisTemplate.opsForValue().set((Object)phoneKey, (Object)"1", (long)countOut.intValue(), TimeUnit.MINUTES);
        } else if (Integer.valueOf(count.toString()) < 100) {
            this.stringRedisTemplate.opsForValue().set((Object)phoneKey, (Object)String.valueOf(Integer.valueOf(count.toString()) + 1), (long)countOut.intValue(), TimeUnit.MINUTES);
        } else {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u5f97\u9a8c\u8bc1\u7801\u6b21\u6570\u8fbe\u5230\u4e0a\u9650\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        String code = RandomStringUtils.randomNumeric((int)6);
        this.stringRedisTemplate.opsForValue().set((Object)token, (Object)code, (long)timeOut.intValue(), TimeUnit.MINUTES);
        AlibabaAliqinFcSmsNumSendResponse res = null;
        try {
            res = AlidayuUtil.sendSms(extend, phone, code, signName, templateCode);
            String msg = res.getMsg();
            if (StringUtils.isBlank((CharSequence)msg) || "\u6210\u529f".equalsIgnoreCase(msg)) {
                return BizResponse.success((Object)token);
            }
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u53d6\u5931\u8d25\uff01");
        }
        catch (ApiException e) {
            e.printStackTrace();
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_LIMIT.getCode(), (String)"\u83b7\u53d6\u5931\u8d25\uff01");
        }
    }

    public BizResponse<Boolean> checkSmsCode(String token, String code, Integer channelType) {
        String[] sl = token.split("_");
        if (sl == null || sl.length == 0 || sl[1] == null) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (!sl[1].equals(channelType.toString())) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        String smsCode = (String)this.stringRedisTemplate.opsForValue().get((Object)token);
        if (StringUtils.isBlank((CharSequence)smsCode)) {
            return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
        }
        if (smsCode.toUpperCase().equals(code.toUpperCase())) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCode.VERIFICATION_CODE_ERROR.getCode(), (String)ErrorCode.VERIFICATION_CODE_ERROR.getMsg());
    }
}

