/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service;

import com.fshows.lifecircle.service.service.utils.AliOSSUtil;
import com.fshows.lifecircle.service.utils.domain.BizResponse;
import com.fshows.lifecircle.service.utils.domain.ErrorCodeEnum;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class AliOssService {
    private static final Logger log = LoggerFactory.getLogger(AliOssService.class);

    public BizResponse<Boolean> uploadFile(String bucketName, String ossKey, String fileName) {
        if (AliOSSUtil.uploadFile(bucketName, ossKey, fileName)) {
            return BizResponse.success((Object)true);
        }
        return BizResponse.fail((String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getCode(), (String)ErrorCodeEnum.REQUEST_METHOD_ERROR.getMsg());
    }

    public BizResponse<Boolean> downloadFile(String bucketName, String key, String filename) {
        AliOSSUtil.downloadFile(bucketName, key, filename);
        return BizResponse.success((Object)true);
    }

    public BizResponse<String> fileUrl(String bucketName, String key) {
        String url = AliOSSUtil.fileUrl(bucketName, key);
        return BizResponse.success((Object)url);
    }

    public BizResponse<String> getToken(Integer imageType) {
        String dirName = null;
        if (imageType == 1) {
            dirName = "logo-images/";
        }
        if (imageType == 2) {
            dirName = "head-images/";
        }
        if (imageType == 3) {
            dirName = "merchantinfo-images/";
        }
        if (imageType == 4) {
            dirName = "qrcode-images/";
        }
        if (StringUtils.isBlank((CharSequence)dirName)) {
            return BizResponse.fail((String)ErrorCodeEnum.INVALID_PARAMETER.getCode(), (String)"\u65e0\u6548\u7684\u7167\u7247\u53c2\u6570");
        }
        return BizResponse.success((Object)AliOSSUtil.getToken(dirName));
    }
}

