/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lifecircle.service.service.utils;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.fshows.lifecircle.service.service.utils.TimeUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.LinkedHashMap;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AliOSSUtil {
    private static final Logger log = LoggerFactory.getLogger(AliOSSUtil.class);

    public static OSSClient getOSSClient() {
        OSSClient ossClient = new OSSClient("http://oss-cn-hangzhou.aliyuncs.com", "LTAIu1PGBk4IHE1a", "OteMAZBwVcoYoyQSQVS1necaExDeLY");
        return ossClient;
    }

    public static boolean uploadFile(String bucketName, String key, String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            File file = new File(filename);
            FileInputStream input = new FileInputStream(file);
            ossClient.putObject(bucketName, key, (InputStream)input);
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> uploadFile \u4e0a\u4f20\u5f02\u5e38, e = {}", (Throwable)e);
            ossClient.shutdown();
            return false;
        }
    }

    public static void downloadFile(String bucketName, String key, String filename) {
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            ossClient.getObject(new GetObjectRequest(bucketName, key), new File(filename));
            ossClient.shutdown();
        }
        catch (Exception e) {
            log.error("AliOSSUtil ---- >> downloadFile \u4e0b\u8f7d\u5f02\u5e38, e = {}", (Throwable)e);
            ossClient.shutdown();
        }
    }

    public static String fileUrl(String bucketName, String key) {
        OSSClient ossClient = null;
        String downloadUrl = "";
        try {
            ossClient = AliOSSUtil.getOSSClient();
            Date time = new Date(TimeUtils.getNow() + 3600000);
            URL url = ossClient.generatePresignedUrl(bucketName, key, time);
            downloadUrl = url.toString();
            ossClient.shutdown();
            return downloadUrl;
        }
        catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38, e = {}", (Throwable)e);
            return downloadUrl;
        }
    }

    public static String getToken(String bucketName, String key) {
        String accessId = key;
        String dir = "saledian-service/";
        String host = "http://" + bucketName + "." + "http://oss-cn-hangzhou.aliyuncs.com";
        OSSClient ossClient = null;
        try {
            ossClient = AliOSSUtil.getOSSClient();
            long expireTime = 30L;
            long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
            java.sql.Date expiration = new java.sql.Date(expireEndTime);
            PolicyConditions policyConds = new PolicyConditions();
            policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
            String postPolicy = ossClient.generatePostPolicy((Date)expiration, policyConds);
            byte[] binaryData = postPolicy.getBytes("utf-8");
            String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
            String postSignature = ossClient.calculatePostSignature(postPolicy);
            LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
            respMap.put("accessid", accessId);
            respMap.put("policy", encodedPolicy);
            respMap.put("signature", postSignature);
            respMap.put("dir", dir);
            respMap.put("host", host);
            respMap.put("expire", String.valueOf(expireEndTime / 1000L));
            JSONObject ja1 = JSONObject.fromObject(respMap);
            System.out.println(ja1.toString());
            return ja1.toString();
        }
        catch (Exception e) {
            ossClient.shutdown();
            log.error("AliOSSUtil ---- >> fileUrl \u4e0b\u8f7d\u5730\u5740\u5f02\u5e38, e = {}", (Throwable)e);
            return null;
        }
    }

    public static void main(String[] args) {
    }
}

